/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.config;

import org.texboobcat.wmb.config.WmbConfig;

public final class Presets {
    private Presets() {
    }

    public static boolean apply(WmbConfig c, String nameRaw) {
        Name name;
        if (c == null || nameRaw == null) {
            return false;
        }
        try {
            name = Name.valueOf(nameRaw.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        switch (name.ordinal()) {
            case 0: {
                Presets.applyVanilla(c);
                break;
            }
            case 1: {
                Presets.applyBalanced(c);
                break;
            }
            case 2: {
                Presets.applyAggressive(c);
            }
        }
        return true;
    }

    public static void applyVanilla(WmbConfig c) {
        c.dab.enabled = true;
        c.dab.nearMultiplier = 1;
        c.dab.midMultiplier = 1;
        c.dab.farMultiplier = 1;
        c.dab.distantMultiplier = 1;
        c.pathfinding.enabled = true;
        c.pathfinding.minRecalcInterval = 0;
        c.pathfinding.groupWindowTicks = 0;
        c.pathfinding.cacheTtlTicks = 0;
        c.pathfinding.experimentalShareEnabled = false;
        c.pathfinding.shareTtlTicks = 0;
        c.culling.enabled = false;
        c.visibility.enabled = false;
    }

    public static void applyBalanced(WmbConfig c) {
        c.dab.enabled = true;
        c.dab.nearMultiplier = 1;
        c.dab.midMultiplier = 2;
        c.dab.farMultiplier = 4;
        c.dab.distantMultiplier = 8;
        c.pathfinding.enabled = true;
        c.pathfinding.minRecalcInterval = 10;
        c.pathfinding.groupWindowTicks = 5;
        c.pathfinding.cacheTtlTicks = 20;
        c.pathfinding.experimentalShareEnabled = false;
        c.pathfinding.shareTtlTicks = 10;
        c.culling.enabled = false;
        c.visibility.enabled = false;
    }

    public static void applyAggressive(WmbConfig c) {
        c.dab.enabled = true;
        c.dab.nearMultiplier = 2;
        c.dab.midMultiplier = 4;
        c.dab.farMultiplier = 8;
        c.dab.distantMultiplier = 16;
        c.pathfinding.enabled = true;
        c.pathfinding.minRecalcInterval = 20;
        c.pathfinding.groupWindowTicks = 10;
        c.pathfinding.cacheTtlTicks = 60;
        c.pathfinding.experimentalShareEnabled = true;
        c.pathfinding.shareTtlTicks = 40;
        c.culling.enabled = true;
        c.culling.minDistance = 192.0;
        c.culling.requireNoTarget = true;
        c.culling.requireNoPath = true;
        c.culling.requireLowMotion = true;
        c.culling.lowMotionSpeed = 0.01;
        c.culling.allowEveryNTicks = 400;
        c.culling.exemptNamed = true;
        c.culling.exemptLeashed = true;
        c.culling.exemptOwned = true;
        c.culling.exemptPersistent = true;
        c.visibility.enabled = true;
        c.visibility.playerChunkRange = 2;
        c.visibility.requireNoTarget = true;
        c.visibility.requireNoPath = true;
        c.visibility.requireLowMotion = true;
        c.visibility.lowMotionSpeed = 0.01;
        c.visibility.allowEveryNTicks = 400;
        c.visibility.exemptNamed = true;
        c.visibility.exemptLeashed = true;
        c.visibility.exemptOwned = true;
        c.visibility.exemptPersistent = true;
    }

    public static enum Name {
        VANILLA,
        BALANCED,
        AGGRESSIVE;

    }
}

