/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public final class WmbConfig {
    private static final String FILE_NAME = "wmb.toml";
    private static final int LATEST_CONFIG_VERSION = 3;
    private static WmbConfig INSTANCE;
    public final Dab dab = new Dab();
    public final AsyncSpawn asyncSpawn = new AsyncSpawn();
    public final AsyncTrackerCfg asyncTracker = new AsyncTrackerCfg();
    public final Checks checks = new Checks();
    public final PathfindingCfg pathfinding = new PathfindingCfg();
    public final MetricsCfg metrics = new MetricsCfg();
    public final ProximityCfg proximity = new ProximityCfg();
    public final TuningCfg tuning = new TuningCfg();
    public final CullingCfg culling = new CullingCfg();
    public final VisibilityCfg visibility = new VisibilityCfg();
    private Path path;

    private WmbConfig() {
    }

    public static WmbConfig get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("WmbConfig not loaded yet. Call WmbConfig.load() during mod init.");
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        if (INSTANCE == null) {
            INSTANCE = new WmbConfig();
        }
        WmbConfig.INSTANCE.path = Platform.getConfigFolder().resolve(FILE_NAME);
        INSTANCE.ensureDefaults();
        INSTANCE.readFromFile();
    }

    public static synchronized void reload() {
        if (INSTANCE == null) {
            WmbConfig.load();
        } else {
            INSTANCE.readFromFile();
        }
    }

    private void ensureDefaults() {
        try {
            boolean needsDefaults;
            boolean bl = needsDefaults = !Files.exists(this.path, new LinkOption[0]) || Files.size(this.path) == 0L;
            if (needsDefaults) {
                Path parent = this.path.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.path).writingMode(WritingMode.REPLACE).sync().build();
                cfg.load();
                cfg.add("configVersion", (Object)3);
                cfg.setComment("configVersion", "WMB config schema version. The mod will auto-upgrade older configs by adding missing keys.");
                cfg.add("dab.enabled", (Object)true);
                cfg.add("dab.d0", (Object)32.0);
                cfg.add("dab.d1", (Object)64.0);
                cfg.add("dab.d2", (Object)128.0);
                cfg.add("dab.multipliers.near", (Object)1);
                cfg.add("dab.multipliers.mid", (Object)2);
                cfg.add("dab.multipliers.far", (Object)4);
                cfg.add("dab.multipliers.distant", (Object)8);
                cfg.add("dab.hysteresisBlocks", (Object)0.0);
                cfg.setComment("dab", "Distance-based AI throttling (DAB).\nd0/d1/d2 are distance thresholds in blocks.\nEntities within d0 use 'near' multiplier; between d0..d1 'mid'; d1..d2 'far'; beyond d2 'distant'.\nMultipliers are tick intervals (1=every tick, 2=every other tick, etc.).\nhysteresisBlocks adds a deadband around thresholds to prevent thrashing when hovering near boundaries.\nYou can override per-entity with [dab.perEntity.\"namespace:id\"] and per-dimension with [dab.perDimension.\"minecraft:the_nether\"].");
                cfg.setComment("dab.enabled", "Enable/disable DAB globally. True=throttle AI by distance; False=vanilla behavior.");
                cfg.setComment("dab.d0", "Nearest distance threshold (blocks). Entities nearer than d0 run at 'near' multiplier.");
                cfg.setComment("dab.d1", "Middle distance threshold (blocks). Entities between d0..d1 run at 'mid' multiplier.");
                cfg.setComment("dab.d2", "Far distance threshold (blocks). Entities between d1..d2 run at 'far' multiplier, beyond d2 'distant'.");
                cfg.setComment("dab.multipliers", "Tick interval multipliers per distance bucket. Smaller=faster AI, larger=slower.");
                cfg.setComment("dab.multipliers.near", "Tick interval for NEAR bucket. 1=every tick (no throttle). Typical 1-2.");
                cfg.setComment("dab.multipliers.mid", "Tick interval for MID bucket. Typical 2-4.");
                cfg.setComment("dab.multipliers.far", "Tick interval for FAR bucket. Typical 4-8.");
                cfg.setComment("dab.multipliers.distant", "Tick interval for DISTANT bucket. Typical 8-16.");
                cfg.setComment("dab.hysteresisBlocks", "Deadband size in blocks applied around d0/d1/d2 to stabilize bucket transitions.");
                cfg.setComment("dab.multipliers", "Tick interval multipliers per distance bucket. 1=near, 2=mid, 4=far, 8=distant by default.");
                cfg.setComment("dab.perEntity", "Per-entity overrides keyed by entity type id (e.g., 'minecraft:villager').\nKeys: exempt (bool), highPriority (bool), near/mid/far/distant (ints).\nWhen exempt or highPriority is true, DAB is disabled for that entity type.");
                cfg.setComment("dab.perDimension", "Per-dimension overrides keyed by dimension id (e.g., 'minecraft:overworld', 'minecraft:the_nether').\nSupported keys in each table: d0, d1, d2 (doubles) and a nested [multipliers] table with near/mid/far/distant (ints).");
                cfg.add("asyncSpawn.enabled", (Object)true);
                cfg.add("asyncSpawn.threadPoolSize", (Object)2);
                cfg.setComment("asyncSpawn", "Asynchronous entity spawning worker pool.");
                cfg.setComment("asyncSpawn.enabled", "Enable/disable off-thread entity spawn preparation.");
                cfg.setComment("asyncSpawn.threadPoolSize", "Number of worker threads for async spawn tasks. 1-4 recommended.");
                cfg.add("asyncTracker.enabled", (Object)true);
                cfg.add("asyncTracker.threadPoolSize", (Object)2);
                cfg.add("asyncTracker.updateInterval", (Object)5);
                cfg.add("asyncTracker.cacheDuration", (Object)20);
                cfg.add("asyncTracker.perDimensionPools", (Object)false);
                cfg.add("asyncTracker.threadPoolSizePerDim", (Object)1);
                cfg.add("asyncTracker.maxTrackingDistance", (Object)96.0);
                cfg.setComment("asyncTracker", "Asynchronous player->entity tracking decisions and packet prep.");
                cfg.setComment("asyncTracker.enabled", "Enable/disable async entity tracker.");
                cfg.setComment("asyncTracker.threadPoolSize", "Worker threads for tracker tasks. Can share with spawn when low.");
                cfg.setComment("asyncTracker.updateInterval", "Ticks between recalculations per player.");
                cfg.setComment("asyncTracker.cacheDuration", "Ticks to reuse visibility result before re-evaluating.");
                cfg.setComment("asyncTracker.perDimensionPools", "If true, use one executor per dimension (overworld/nether/end) to isolate load.");
                cfg.setComment("asyncTracker.threadPoolSizePerDim", "Core threads for each per-dimension tracker executor when perDimensionPools is true.");
                cfg.setComment("asyncTracker.maxTrackingDistance", "Maximum block distance for tracking decisions (2D horizontal). Typical 96-160.");
                cfg.add("proximity.updateIntervalTicks", (Object)5);
                cfg.setComment("proximity", "Proximity snapshot service used by DAB.\nupdateIntervalTicks controls how often player positions are snapshotted (default 5 ticks).\nLarger values reduce CPU overhead but can make DAB react a bit slower to fast-moving players.");
                cfg.setComment("proximity.updateIntervalTicks", "Ticks between proximity snapshot refreshes. Set 1-10 for a good balance.");
                cfg.add("checks.suffocationInterval", (Object)20);
                cfg.setComment("checks", "Vanilla safety checks tuned for performance.");
                cfg.setComment("checks.suffocationInterval", "Ticks between suffocation checks per entity (higher=less CPU, slower response).");
                cfg.add("pathfinding.enabled", (Object)true);
                cfg.add("pathfinding.minRecalcInterval", (Object)10);
                cfg.add("pathfinding.groupWindowTicks", (Object)5);
                cfg.add("pathfinding.cacheTtlTicks", (Object)20);
                cfg.add("pathfinding.experimentalShareEnabled", (Object)false);
                cfg.add("pathfinding.shareTtlTicks", (Object)10);
                cfg.setComment("pathfinding", "Pathfinding scheduler and caches.");
                cfg.setComment("pathfinding.enabled", "Enable pathfinding optimizations and scheduling tweaks.");
                cfg.setComment("pathfinding.minRecalcInterval", "Minimum ticks between path recalculations per mob (actuator used by tuner).");
                cfg.setComment("pathfinding.groupWindowTicks", "Window size in ticks to group mobs and stagger recalculations.");
                cfg.setComment("pathfinding.cacheTtlTicks", "How long cached paths are kept before expiring.");
                cfg.setComment("pathfinding.experimentalShareEnabled", "Experimental: share path results across similar mobs. May be unstable.");
                cfg.setComment("pathfinding.shareTtlTicks", "TTL for shared path entries if sharing is enabled.");
                cfg.add("metrics.enabled", (Object)false);
                cfg.setComment("metrics", "Lightweight internal counters for /wmb stats. Small overhead when enabled.");
                cfg.setComment("metrics.enabled", "Enable/disable WMB metrics collection.");
                cfg.add("tuning.enabled", (Object)false);
                cfg.add("tuning.targetTickMs", (Object)45.0);
                cfg.add("tuning.windowTicks", (Object)200);
                cfg.add("tuning.cooldownTicks", (Object)200);
                cfg.add("tuning.minRecalcMin", (Object)0);
                cfg.add("tuning.minRecalcMax", (Object)40);
                cfg.add("tuning.kp", (Object)0.0);
                cfg.add("tuning.ki", (Object)0.0);
                cfg.add("tuning.kd", (Object)0.0);
                cfg.add("tuning.maxStepPerWindow", (Object)1);
                cfg.add("tuning.integralMaxAbs", (Object)200.0);
                cfg.setComment("tuning", "Auto-tuning of performance-sensitive parameters.\ntargetTickMs: target average tick duration (ms).\nwindowTicks: number of ticks per averaging window.\ncooldownTicks: minimum ticks between adjustments.\nminRecalcMin/max: clamps for pathfinding.minRecalcInterval (actuator).\nkp/ki/kd: PID gains. If all zero, falls back to simple step controller.\nmaxStepPerWindow: maximum integer change applied per window.\nintegralMaxAbs: absolute clamp for the integral term to avoid windup.");
                cfg.setComment("tuning.enabled", "Enable/disable the auto tuner.");
                cfg.setComment("tuning.targetTickMs", "Target average tick duration in milliseconds (50.0 ms for 20 TPS).");
                cfg.setComment("tuning.windowTicks", "How many ticks to average over before considering an adjustment.");
                cfg.setComment("tuning.cooldownTicks", "Minimum ticks to wait between successive adjustments.");
                cfg.setComment("tuning.minRecalcMin", "Lower bound clamp for pathfinding.minRecalcInterval adjustments.");
                cfg.setComment("tuning.minRecalcMax", "Upper bound clamp for pathfinding.minRecalcInterval adjustments.");
                cfg.setComment("tuning.kp", "Proportional gain. Reacts to current error (target - average). Higher=more aggressive.");
                cfg.setComment("tuning.ki", "Integral gain. Reacts to accumulated error over time. Helps eliminate steady-state offset.");
                cfg.setComment("tuning.kd", "Derivative gain. Reacts to change in error, damping overshoot and oscillation.");
                cfg.setComment("tuning.maxStepPerWindow", "Maximum absolute change applied to minRecalcInterval per window.");
                cfg.setComment("tuning.integralMaxAbs", "Clamp for integral term to avoid windup (absolute value).");
                cfg.add("culling.enabled", (Object)false);
                cfg.add("culling.minDistance", (Object)160.0);
                cfg.add("culling.requireNoTarget", (Object)true);
                cfg.add("culling.requireNoPath", (Object)true);
                cfg.add("culling.requireLowMotion", (Object)true);
                cfg.add("culling.lowMotionSpeed", (Object)0.01);
                cfg.add("culling.allowEveryNTicks", (Object)200);
                cfg.add("culling.exemptNamed", (Object)true);
                cfg.add("culling.exemptLeashed", (Object)true);
                cfg.add("culling.exemptOwned", (Object)true);
                cfg.add("culling.exemptPersistent", (Object)true);
                cfg.setComment("culling", "Optional: skip AI for far, idle mobs with multiple safety gates.");
                cfg.setComment("culling.enabled", "Enable/disable culling rules.");
                cfg.setComment("culling.minDistance", "Only consider mobs at least this many blocks from nearest player.");
                cfg.setComment("culling.requireNoTarget", "Require that the mob currently has no target to be eligible.");
                cfg.setComment("culling.requireNoPath", "Require that the mob currently has no path to be eligible.");
                cfg.setComment("culling.requireLowMotion", "Require that the mob is moving slower than lowMotionSpeed.");
                cfg.setComment("culling.lowMotionSpeed", "Low motion threshold in blocks/tick to consider mob 'idle'.");
                cfg.setComment("culling.allowEveryNTicks", "Even when eligible, allow AI every N ticks to avoid starvation.");
                cfg.setComment("culling.exemptNamed", "Never cull named mobs.");
                cfg.setComment("culling.exemptLeashed", "Never cull leashed mobs.");
                cfg.setComment("culling.exemptOwned", "Never cull tamed/owned mobs.");
                cfg.setComment("culling.exemptPersistent", "Never cull mobs marked persistent.");
                cfg.add("visibility.enabled", (Object)false);
                cfg.add("visibility.playerChunkRange", (Object)3);
                cfg.add("visibility.requireNoTarget", (Object)true);
                cfg.add("visibility.requireNoPath", (Object)true);
                cfg.add("visibility.requireLowMotion", (Object)true);
                cfg.add("visibility.lowMotionSpeed", (Object)0.01);
                cfg.add("visibility.allowEveryNTicks", (Object)200);
                cfg.add("visibility.exemptNamed", (Object)true);
                cfg.add("visibility.exemptLeashed", (Object)true);
                cfg.add("visibility.exemptOwned", (Object)true);
                cfg.add("visibility.exemptPersistent", (Object)true);
                cfg.setComment("visibility", "Optional: skip AI for mobs far outside any player's chunk range, with safety gates.");
                cfg.setComment("visibility.enabled", "Enable/disable visibility-based culling rules.");
                cfg.setComment("visibility.playerChunkRange", "Chebyshev chunk distance around players considered 'active'.");
                cfg.setComment("visibility.requireNoTarget", "Require that the mob currently has no target to be eligible.");
                cfg.setComment("visibility.requireNoPath", "Require that the mob currently has no path to be eligible.");
                cfg.setComment("visibility.requireLowMotion", "Require that the mob is moving slower than lowMotionSpeed.");
                cfg.setComment("visibility.lowMotionSpeed", "Low motion threshold in blocks/tick to consider mob 'idle'.");
                cfg.setComment("visibility.allowEveryNTicks", "Even when eligible, allow AI every N ticks to avoid starvation.");
                cfg.setComment("visibility.exemptNamed", "Never apply visibility culling to named mobs.");
                cfg.setComment("visibility.exemptLeashed", "Never apply visibility culling to leashed mobs.");
                cfg.setComment("visibility.exemptOwned", "Never apply visibility culling to tamed/owned mobs.");
                cfg.setComment("visibility.exemptPersistent", "Never apply visibility culling to mobs marked persistent.");
                cfg.save();
                cfg.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create default WMB config", e);
        }
    }

    private void readFromFile() {
        try (CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.path).sync().build();){
            cfg.load();
            boolean changed = false;
            int existingVersion = (Integer)cfg.getOrElse("configVersion", (Object)0);
            changed |= this.mergeMissingDefaults(cfg);
            if (existingVersion < 3) {
                cfg.set("configVersion", (Object)3);
                changed = true;
            } else if (!cfg.contains("configVersion")) {
                cfg.add("configVersion", (Object)3);
                changed = true;
            }
            if (changed) {
                cfg.save();
            }
            this.dab.enabled = (Boolean)cfg.getOrElse("dab.enabled", (Object)true);
            this.dab.d0 = (Double)cfg.getOrElse("dab.d0", (Object)32.0);
            this.dab.d1 = (Double)cfg.getOrElse("dab.d1", (Object)64.0);
            this.dab.d2 = (Double)cfg.getOrElse("dab.d2", (Object)128.0);
            CommentedConfig mult = (CommentedConfig)cfg.get("dab.multipliers");
            if (mult != null) {
                this.dab.nearMultiplier = (Integer)mult.getOrElse("near", (Object)1);
                this.dab.midMultiplier = (Integer)mult.getOrElse("mid", (Object)2);
                this.dab.farMultiplier = (Integer)mult.getOrElse("far", (Object)4);
                this.dab.distantMultiplier = (Integer)mult.getOrElse("distant", (Object)8);
            } else {
                this.dab.nearMultiplier = 1;
                this.dab.midMultiplier = 2;
                this.dab.farMultiplier = 4;
                this.dab.distantMultiplier = 8;
            }
            this.dab.hysteresisBlocks = (Double)cfg.getOrElse("dab.hysteresisBlocks", (Object)0.0);
            this.dab.perEntityOverrides.clear();
            CommentedConfig perEntity = (CommentedConfig)cfg.get("dab.perEntity");
            if (perEntity != null) {
                for (String key : perEntity.valueMap().keySet()) {
                    Object sub = perEntity.get(key);
                    if (!(sub instanceof CommentedConfig)) continue;
                    CommentedConfig subCfg = (CommentedConfig)sub;
                    PerEntityPolicy p = new PerEntityPolicy();
                    p.exempt = (Boolean)subCfg.getOrElse("exempt", (Object)false);
                    p.highPriority = (Boolean)subCfg.getOrElse("highPriority", (Object)false);
                    if (subCfg.contains("near")) {
                        p.nearMultiplier = subCfg.getInt("near");
                    }
                    if (subCfg.contains("mid")) {
                        p.midMultiplier = subCfg.getInt("mid");
                    }
                    if (subCfg.contains("far")) {
                        p.farMultiplier = subCfg.getInt("far");
                    }
                    if (subCfg.contains("distant")) {
                        p.distantMultiplier = subCfg.getInt("distant");
                    }
                    this.dab.perEntityOverrides.put(key, p);
                }
            }
            this.dab.perDimension.clear();
            CommentedConfig perDim = (CommentedConfig)cfg.get("dab.perDimension");
            if (perDim != null) {
                for (String dimKey : perDim.valueMap().keySet()) {
                    CommentedConfig dm;
                    Number n;
                    Object v;
                    Object sub = perDim.get(dimKey);
                    if (!(sub instanceof CommentedConfig)) continue;
                    CommentedConfig subCfg = (CommentedConfig)sub;
                    DimensionOverrides d = new DimensionOverrides();
                    if (subCfg.contains("d0") && (v = subCfg.get("d0")) instanceof Number) {
                        n = (Number)v;
                        d.d0 = n.doubleValue();
                    }
                    if (subCfg.contains("d1") && (v = subCfg.get("d1")) instanceof Number) {
                        n = (Number)v;
                        d.d1 = n.doubleValue();
                    }
                    if (subCfg.contains("d2") && (v = subCfg.get("d2")) instanceof Number) {
                        n = (Number)v;
                        d.d2 = n.doubleValue();
                    }
                    if ((dm = (CommentedConfig)subCfg.get("multipliers")) != null) {
                        if (dm.contains("near")) {
                            d.nearMultiplier = dm.getInt("near");
                        }
                        if (dm.contains("mid")) {
                            d.midMultiplier = dm.getInt("mid");
                        }
                        if (dm.contains("far")) {
                            d.farMultiplier = dm.getInt("far");
                        }
                        if (dm.contains("distant")) {
                            d.distantMultiplier = dm.getInt("distant");
                        }
                    }
                    this.dab.perDimension.put(dimKey, d);
                }
            }
            this.asyncSpawn.enabled = (Boolean)cfg.getOrElse("asyncSpawn.enabled", (Object)true);
            this.asyncSpawn.threadPoolSize = (Integer)cfg.getOrElse("asyncSpawn.threadPoolSize", (Object)2);
            this.asyncTracker.enabled = (Boolean)cfg.getOrElse("asyncTracker.enabled", (Object)true);
            this.asyncTracker.threadPoolSize = (Integer)cfg.getOrElse("asyncTracker.threadPoolSize", (Object)2);
            this.asyncTracker.updateInterval = (Integer)cfg.getOrElse("asyncTracker.updateInterval", (Object)5);
            this.asyncTracker.cacheDuration = (Integer)cfg.getOrElse("asyncTracker.cacheDuration", (Object)20);
            this.asyncTracker.perDimensionPools = (Boolean)cfg.getOrElse("asyncTracker.perDimensionPools", (Object)false);
            this.asyncTracker.threadPoolSizePerDim = (Integer)cfg.getOrElse("asyncTracker.threadPoolSizePerDim", (Object)1);
            this.asyncTracker.maxTrackingDistance = (Double)cfg.getOrElse("asyncTracker.maxTrackingDistance", (Object)96.0);
            this.proximity.updateIntervalTicks = (Integer)cfg.getOrElse("proximity.updateIntervalTicks", (Object)5);
            this.pathfinding.minRecalcInterval = (Integer)cfg.getOrElse("pathfinding.minRecalcInterval", (Object)10);
            this.pathfinding.groupWindowTicks = (Integer)cfg.getOrElse("pathfinding.groupWindowTicks", (Object)5);
            this.pathfinding.cacheTtlTicks = (Integer)cfg.getOrElse("pathfinding.cacheTtlTicks", (Object)20);
            this.pathfinding.experimentalShareEnabled = (Boolean)cfg.getOrElse("pathfinding.experimentalShareEnabled", (Object)false);
            this.pathfinding.shareTtlTicks = (Integer)cfg.getOrElse("pathfinding.shareTtlTicks", (Object)10);
            this.metrics.enabled = (Boolean)cfg.getOrElse("metrics.enabled", (Object)false);
            this.tuning.enabled = (Boolean)cfg.getOrElse("tuning.enabled", (Object)false);
            this.tuning.targetTickMs = (Double)cfg.getOrElse("tuning.targetTickMs", (Object)45.0);
            this.tuning.windowTicks = (Integer)cfg.getOrElse("tuning.windowTicks", (Object)200);
            this.tuning.cooldownTicks = (Integer)cfg.getOrElse("tuning.cooldownTicks", (Object)200);
            this.tuning.minRecalcMin = (Integer)cfg.getOrElse("tuning.minRecalcMin", (Object)0);
            this.tuning.minRecalcMax = (Integer)cfg.getOrElse("tuning.minRecalcMax", (Object)40);
            this.tuning.kp = (Double)cfg.getOrElse("tuning.kp", (Object)0.0);
            this.tuning.ki = (Double)cfg.getOrElse("tuning.ki", (Object)0.0);
            this.tuning.kd = (Double)cfg.getOrElse("tuning.kd", (Object)0.0);
            this.tuning.maxStepPerWindow = (Integer)cfg.getOrElse("tuning.maxStepPerWindow", (Object)1);
            this.tuning.integralMaxAbs = (Double)cfg.getOrElse("tuning.integralMaxAbs", (Object)200.0);
            this.culling.enabled = (Boolean)cfg.getOrElse("culling.enabled", (Object)false);
            this.culling.minDistance = (Double)cfg.getOrElse("culling.minDistance", (Object)160.0);
            this.culling.requireNoTarget = (Boolean)cfg.getOrElse("culling.requireNoTarget", (Object)true);
            this.culling.requireNoPath = (Boolean)cfg.getOrElse("culling.requireNoPath", (Object)true);
            this.culling.requireLowMotion = (Boolean)cfg.getOrElse("culling.requireLowMotion", (Object)true);
            this.culling.lowMotionSpeed = (Double)cfg.getOrElse("culling.lowMotionSpeed", (Object)0.01);
            this.culling.allowEveryNTicks = (Integer)cfg.getOrElse("culling.allowEveryNTicks", (Object)200);
            this.culling.exemptNamed = (Boolean)cfg.getOrElse("culling.exemptNamed", (Object)true);
            this.culling.exemptLeashed = (Boolean)cfg.getOrElse("culling.exemptLeashed", (Object)true);
            this.culling.exemptOwned = (Boolean)cfg.getOrElse("culling.exemptOwned", (Object)true);
            this.culling.exemptPersistent = (Boolean)cfg.getOrElse("culling.exemptPersistent", (Object)true);
            this.visibility.enabled = (Boolean)cfg.getOrElse("visibility.enabled", (Object)false);
            this.visibility.playerChunkRange = (Integer)cfg.getOrElse("visibility.playerChunkRange", (Object)3);
            this.visibility.requireNoTarget = (Boolean)cfg.getOrElse("visibility.requireNoTarget", (Object)true);
            this.visibility.requireNoPath = (Boolean)cfg.getOrElse("visibility.requireNoPath", (Object)true);
            this.visibility.requireLowMotion = (Boolean)cfg.getOrElse("visibility.requireLowMotion", (Object)true);
            this.visibility.lowMotionSpeed = (Double)cfg.getOrElse("visibility.lowMotionSpeed", (Object)0.01);
            this.visibility.allowEveryNTicks = (Integer)cfg.getOrElse("visibility.allowEveryNTicks", (Object)200);
            this.visibility.exemptNamed = (Boolean)cfg.getOrElse("visibility.exemptNamed", (Object)true);
            this.visibility.exemptLeashed = (Boolean)cfg.getOrElse("visibility.exemptLeashed", (Object)true);
            this.visibility.exemptOwned = (Boolean)cfg.getOrElse("visibility.exemptOwned", (Object)true);
            this.visibility.exemptPersistent = (Boolean)cfg.getOrElse("visibility.exemptPersistent", (Object)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read WMB config", e);
        }
    }

    private boolean mergeMissingDefaults(CommentedFileConfig cfg) {
        boolean changed = false;
        changed |= this.addIfMissing(cfg, "dab.enabled", true, "Enable/disable DAB globally. True=throttle AI by distance; False=vanilla behavior.");
        changed |= this.addIfMissing(cfg, "dab.d0", 32.0, "Nearest distance threshold (blocks). Entities nearer than d0 run at 'near' multiplier.");
        changed |= this.addIfMissing(cfg, "dab.d1", 64.0, "Middle distance threshold (blocks). Entities between d0..d1 run at 'mid' multiplier.");
        changed |= this.addIfMissing(cfg, "dab.d2", 128.0, "Far distance threshold (blocks). Entities between d1..d2 run at 'far' multiplier, beyond d2 'distant'.");
        changed |= this.addIfMissing(cfg, "dab.multipliers.near", 1, null);
        changed |= this.addIfMissing(cfg, "dab.multipliers.mid", 2, null);
        changed |= this.addIfMissing(cfg, "dab.multipliers.far", 4, null);
        changed |= this.addIfMissing(cfg, "dab.multipliers.distant", 8, null);
        changed |= this.addIfMissing(cfg, "dab.hysteresisBlocks", 0.0, "Deadband size in blocks applied around d0/d1/d2 to stabilize bucket transitions.");
        changed |= this.addIfMissing(cfg, "asyncSpawn.enabled", true, "Enable/disable off-thread entity spawn preparation.");
        changed |= this.addIfMissing(cfg, "asyncSpawn.threadPoolSize", 2, "Number of worker threads for async spawn tasks. 1-4 recommended.");
        changed |= this.addIfMissing(cfg, "asyncTracker.enabled", true, "Enable/disable async entity tracker.");
        changed |= this.addIfMissing(cfg, "asyncTracker.threadPoolSize", 2, "Worker threads for tracker tasks. Can share with spawn when low.");
        changed |= this.addIfMissing(cfg, "asyncTracker.updateInterval", 5, "Ticks between recalculations per player.");
        changed |= this.addIfMissing(cfg, "asyncTracker.cacheDuration", 20, "Ticks to reuse visibility result before re-evaluating.");
        changed |= this.addIfMissing(cfg, "asyncTracker.perDimensionPools", false, "If true, use one executor per dimension (overworld/nether/end) to isolate load.");
        changed |= this.addIfMissing(cfg, "asyncTracker.threadPoolSizePerDim", 1, "Core threads for each per-dimension tracker executor when perDimensionPools is true.");
        changed |= this.addIfMissing(cfg, "asyncTracker.maxTrackingDistance", 96.0, "Maximum block distance for tracking decisions (2D horizontal). Typical 96-160.");
        changed |= this.addIfMissing(cfg, "proximity.updateIntervalTicks", 5, "Ticks between proximity snapshot refreshes. Set 1-10 for a good balance.");
        changed |= this.addIfMissing(cfg, "checks.suffocationInterval", 20, "Ticks between suffocation checks per entity (higher=less CPU, slower response).");
        changed |= this.addIfMissing(cfg, "pathfinding.enabled", true, "Enable pathfinding optimizations and scheduling tweaks.");
        changed |= this.addIfMissing(cfg, "pathfinding.minRecalcInterval", 10, "Minimum ticks between path recalculations per mob (actuator used by tuner).");
        changed |= this.addIfMissing(cfg, "pathfinding.groupWindowTicks", 5, "Window size in ticks to group mobs and stagger recalculations.");
        changed |= this.addIfMissing(cfg, "pathfinding.cacheTtlTicks", 20, "How long cached paths are kept before expiring.");
        changed |= this.addIfMissing(cfg, "pathfinding.experimentalShareEnabled", false, "Experimental: share path results across similar mobs. May be unstable.");
        changed |= this.addIfMissing(cfg, "pathfinding.shareTtlTicks", 10, "TTL for shared path entries if sharing is enabled.");
        changed |= this.addIfMissing(cfg, "metrics.enabled", false, "Enable/disable WMB metrics collection.");
        changed |= this.addIfMissing(cfg, "tuning.enabled", false, "Enable/disable the auto tuner.");
        changed |= this.addIfMissing(cfg, "tuning.targetTickMs", 45.0, "Target average tick duration in milliseconds (50.0 ms for 20 TPS).");
        changed |= this.addIfMissing(cfg, "tuning.windowTicks", 200, "How many ticks to average over before considering an adjustment.");
        changed |= this.addIfMissing(cfg, "tuning.cooldownTicks", 200, "Minimum ticks to wait between successive adjustments.");
        changed |= this.addIfMissing(cfg, "tuning.minRecalcMin", 0, "Lower bound clamp for pathfinding.minRecalcInterval adjustments.");
        changed |= this.addIfMissing(cfg, "tuning.minRecalcMax", 40, "Upper bound clamp for pathfinding.minRecalcInterval adjustments.");
        changed |= this.addIfMissing(cfg, "tuning.kp", 0.0, null);
        changed |= this.addIfMissing(cfg, "tuning.ki", 0.0, null);
        changed |= this.addIfMissing(cfg, "tuning.kd", 0.0, null);
        changed |= this.addIfMissing(cfg, "tuning.maxStepPerWindow", 1, "Maximum absolute change applied to minRecalcInterval per window.");
        changed |= this.addIfMissing(cfg, "tuning.integralMaxAbs", 200.0, "Clamp for integral term to avoid windup (absolute value).");
        changed |= this.addIfMissing(cfg, "culling.enabled", false, "Enable/disable culling rules.");
        changed |= this.addIfMissing(cfg, "culling.minDistance", 160.0, "Only consider mobs at least this many blocks from nearest player.");
        changed |= this.addIfMissing(cfg, "culling.requireNoTarget", true, "Require that the mob currently has no target to be eligible.");
        changed |= this.addIfMissing(cfg, "culling.requireNoPath", true, "Require that the mob currently has no path to be eligible.");
        changed |= this.addIfMissing(cfg, "culling.requireLowMotion", true, "Require that the mob is moving slower than lowMotionSpeed.");
        changed |= this.addIfMissing(cfg, "culling.lowMotionSpeed", 0.01, "Low motion threshold in blocks/tick to consider mob 'idle'.");
        changed |= this.addIfMissing(cfg, "culling.allowEveryNTicks", 200, "Even when eligible, allow AI every N ticks to avoid starvation.");
        changed |= this.addIfMissing(cfg, "culling.exemptNamed", true, "Never cull named mobs.");
        changed |= this.addIfMissing(cfg, "culling.exemptLeashed", true, "Never cull leashed mobs.");
        changed |= this.addIfMissing(cfg, "culling.exemptOwned", true, "Never cull tamed/owned mobs.");
        changed |= this.addIfMissing(cfg, "culling.exemptPersistent", true, "Never cull mobs marked persistent.");
        changed |= this.addIfMissing(cfg, "visibility.enabled", false, "Enable/disable visibility-based culling rules.");
        changed |= this.addIfMissing(cfg, "visibility.playerChunkRange", 3, "Chebyshev chunk distance around players considered 'active'.");
        changed |= this.addIfMissing(cfg, "visibility.requireNoTarget", true, "Require that the mob currently has no target to be eligible.");
        changed |= this.addIfMissing(cfg, "visibility.requireNoPath", true, "Require that the mob currently has no path to be eligible.");
        changed |= this.addIfMissing(cfg, "visibility.requireLowMotion", true, "Require that the mob is moving slower than lowMotionSpeed.");
        changed |= this.addIfMissing(cfg, "visibility.lowMotionSpeed", 0.01, "Low motion threshold in blocks/tick to consider mob 'idle'.");
        changed |= this.addIfMissing(cfg, "visibility.allowEveryNTicks", 200, "Even when eligible, allow AI every N ticks to avoid starvation.");
        changed |= this.addIfMissing(cfg, "visibility.exemptNamed", true, "Never apply visibility culling to named mobs.");
        changed |= this.addIfMissing(cfg, "visibility.exemptLeashed", true, "Never apply visibility culling to leashed mobs.");
        changed |= this.addIfMissing(cfg, "visibility.exemptOwned", true, "Never apply visibility culling to tamed/owned mobs.");
        return changed |= this.addIfMissing(cfg, "visibility.exemptPersistent", true, "Never apply visibility culling to mobs marked persistent.");
    }

    private boolean addIfMissing(CommentedFileConfig cfg, String key, Object value, String comment) {
        if (!cfg.contains(key)) {
            cfg.add(key, value);
            if (comment != null) {
                cfg.setComment(key, comment);
            }
            return true;
        }
        return false;
    }

    public static final class Dab {
        public boolean enabled;
        public double d0;
        public double d1;
        public double d2;
        public int nearMultiplier;
        public int midMultiplier;
        public int farMultiplier;
        public int distantMultiplier;
        public Map<String, PerEntityPolicy> perEntityOverrides = new HashMap<String, PerEntityPolicy>();
        public double hysteresisBlocks = 0.0;
        public Map<String, DimensionOverrides> perDimension = new HashMap<String, DimensionOverrides>();
    }

    public static final class AsyncSpawn {
        public boolean enabled;
        public int threadPoolSize;
    }

    public static final class AsyncTrackerCfg {
        public boolean enabled;
        public int threadPoolSize;
        public int updateInterval;
        public int cacheDuration;
        public boolean perDimensionPools;
        public int threadPoolSizePerDim;
        public double maxTrackingDistance;
    }

    public static final class Checks {
        public int suffocationInterval;
    }

    public static final class PathfindingCfg {
        public boolean enabled;
        public int minRecalcInterval;
        public int groupWindowTicks;
        public int cacheTtlTicks;
        public boolean experimentalShareEnabled;
        public int shareTtlTicks;
    }

    public static final class MetricsCfg {
        public boolean enabled;
    }

    public static final class ProximityCfg {
        public int updateIntervalTicks;
    }

    public static final class TuningCfg {
        public boolean enabled;
        public double targetTickMs;
        public int windowTicks;
        public int cooldownTicks;
        public int minRecalcMin;
        public int minRecalcMax;
        public double kp = 0.0;
        public double ki = 0.0;
        public double kd = 0.0;
        public int maxStepPerWindow = 1;
        public double integralMaxAbs = 200.0;
    }

    public static final class CullingCfg {
        public boolean enabled;
        public double minDistance;
        public boolean requireNoTarget;
        public boolean requireNoPath;
        public boolean requireLowMotion;
        public double lowMotionSpeed;
        public int allowEveryNTicks;
        public boolean exemptNamed;
        public boolean exemptLeashed;
        public boolean exemptOwned;
        public boolean exemptPersistent;
    }

    public static final class VisibilityCfg {
        public boolean enabled;
        public int playerChunkRange;
        public boolean requireNoTarget;
        public boolean requireNoPath;
        public boolean requireLowMotion;
        public double lowMotionSpeed;
        public int allowEveryNTicks;
        public boolean exemptNamed;
        public boolean exemptLeashed;
        public boolean exemptOwned;
        public boolean exemptPersistent;
    }

    public static final class PerEntityPolicy {
        public boolean exempt = false;
        public boolean highPriority = false;
        public Integer nearMultiplier = null;
        public Integer midMultiplier = null;
        public Integer farMultiplier = null;
        public Integer distantMultiplier = null;
    }

    public static final class DimensionOverrides {
        public Double d0 = null;
        public Double d1 = null;
        public Double d2 = null;
        public Integer nearMultiplier = null;
        public Integer midMultiplier = null;
        public Integer farMultiplier = null;
        public Integer distantMultiplier = null;
    }
}

