/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.metrics;

import java.util.concurrent.atomic.AtomicLong;

public final class Metrics {
    private static final AtomicLong AI_STEPS_EXECUTED = new AtomicLong();
    private static final AtomicLong AI_STEPS_SKIPPED = new AtomicLong();
    private static final AtomicLong AI_STEPS_SKIPPED_DAB = new AtomicLong();
    private static final AtomicLong AI_STEPS_SKIPPED_ENTITY = new AtomicLong();
    private static final AtomicLong AI_STEPS_SKIPPED_VISIBILITY = new AtomicLong();
    private static final AtomicLong INTERVAL_SUM = new AtomicLong();
    private static final AtomicLong INTERVAL_COUNT = new AtomicLong();
    private static final AtomicLong PATHFIND_NANOS = new AtomicLong();
    private static final AtomicLong PATHFIND_COUNT = new AtomicLong();
    private static final AtomicLong SPAWN_FILL_NANOS = new AtomicLong();
    private static final AtomicLong SPAWN_FILL_BATCHES = new AtomicLong();
    private static final AtomicLong SPAWN_CANDIDATE_COUNT = new AtomicLong();
    private static final AtomicLong PATH_SHARED_PUBLISHED = new AtomicLong();
    private static final AtomicLong PATH_SHARED_CLAIMED = new AtomicLong();
    private static final AtomicLong TICK_NANOS_TOTAL = new AtomicLong();
    private static final AtomicLong TICK_COUNT = new AtomicLong();
    private static final AtomicLong TRACKER_TASK_NANOS = new AtomicLong();
    private static final AtomicLong TRACKER_TASK_COUNT = new AtomicLong();
    private static final AtomicLong TRACKER_QUEUE_SIZE = new AtomicLong();

    private Metrics() {
    }

    public static void onAiStepExecuted(int interval) {
        AI_STEPS_EXECUTED.incrementAndGet();
        INTERVAL_SUM.addAndGet(interval);
        INTERVAL_COUNT.incrementAndGet();
    }

    public static void onAiStepSkipped() {
        AI_STEPS_SKIPPED.incrementAndGet();
    }

    public static void onAiStepSkippedDab() {
        AI_STEPS_SKIPPED.incrementAndGet();
        AI_STEPS_SKIPPED_DAB.incrementAndGet();
    }

    public static void onAiStepSkippedEntity() {
        AI_STEPS_SKIPPED.incrementAndGet();
        AI_STEPS_SKIPPED_ENTITY.incrementAndGet();
    }

    public static void onAiStepSkippedVisibility() {
        AI_STEPS_SKIPPED.incrementAndGet();
        AI_STEPS_SKIPPED_VISIBILITY.incrementAndGet();
    }

    public static void onPathfindDuration(long nanos) {
        if (nanos <= 0L) {
            return;
        }
        PATHFIND_NANOS.addAndGet(nanos);
        PATHFIND_COUNT.incrementAndGet();
    }

    public static void onAsyncSpawnFill(long nanos, int candidates) {
        if (nanos <= 0L) {
            return;
        }
        SPAWN_FILL_NANOS.addAndGet(nanos);
        SPAWN_FILL_BATCHES.incrementAndGet();
        if (candidates > 0) {
            SPAWN_CANDIDATE_COUNT.addAndGet(candidates);
        }
    }

    public static void onPathSharedPublished() {
        PATH_SHARED_PUBLISHED.incrementAndGet();
    }

    public static void onPathSharedClaimed() {
        PATH_SHARED_CLAIMED.incrementAndGet();
    }

    public static void onServerTickDuration(long nanos) {
        if (nanos <= 0L) {
            return;
        }
        TICK_NANOS_TOTAL.addAndGet(nanos);
        TICK_COUNT.incrementAndGet();
    }

    public static void onTrackerTaskDuration(long nanos) {
        if (nanos <= 0L) {
            return;
        }
        TRACKER_TASK_NANOS.addAndGet(nanos);
        TRACKER_TASK_COUNT.incrementAndGet();
    }

    public static void onTrackerQueueSize(int size) {
        if (size < 0) {
            return;
        }
        TRACKER_QUEUE_SIZE.set(size);
    }

    public static Snapshot snapshot() {
        return new Snapshot(AI_STEPS_EXECUTED.get(), AI_STEPS_SKIPPED.get(), AI_STEPS_SKIPPED_DAB.get(), AI_STEPS_SKIPPED_ENTITY.get(), AI_STEPS_SKIPPED_VISIBILITY.get(), INTERVAL_SUM.get(), INTERVAL_COUNT.get(), PATHFIND_NANOS.get(), PATHFIND_COUNT.get(), SPAWN_FILL_NANOS.get(), SPAWN_FILL_BATCHES.get(), SPAWN_CANDIDATE_COUNT.get(), PATH_SHARED_PUBLISHED.get(), PATH_SHARED_CLAIMED.get(), TICK_NANOS_TOTAL.get(), TICK_COUNT.get(), TRACKER_TASK_NANOS.get(), TRACKER_TASK_COUNT.get(), TRACKER_QUEUE_SIZE.get());
    }

    public static final class Snapshot {
        public final long aiStepsExecuted;
        public final long aiStepsSkipped;
        public final long aiStepsSkippedDab;
        public final long aiStepsSkippedEntity;
        public final long aiStepsSkippedVisibility;
        public final long lastIntervalSum;
        public final long lastIntervalCount;
        public final long pathfindNanos;
        public final long pathfindCount;
        public final long spawnFillNanos;
        public final long spawnFillBatches;
        public final long spawnCandidateCount;
        public final long pathSharedPublished;
        public final long pathSharedClaimed;
        public final long tickNanosTotal;
        public final long tickCount;
        public final long trackerTaskNanos;
        public final long trackerTaskCount;
        public final long trackerQueueSize;

        public Snapshot(long executed, long skipped, long skippedDab, long skippedEntity, long skippedVisibility, long intervalSum, long intervalCount, long pathfindNanos, long pathfindCount, long spawnFillNanos, long spawnFillBatches, long spawnCandidateCount, long pathSharedPublished, long pathSharedClaimed, long tickNanosTotal, long tickCount, long trackerTaskNanos, long trackerTaskCount, long trackerQueueSize) {
            this.aiStepsExecuted = executed;
            this.aiStepsSkipped = skipped;
            this.aiStepsSkippedDab = skippedDab;
            this.aiStepsSkippedEntity = skippedEntity;
            this.aiStepsSkippedVisibility = skippedVisibility;
            this.lastIntervalSum = intervalSum;
            this.lastIntervalCount = intervalCount;
            this.pathfindNanos = pathfindNanos;
            this.pathfindCount = pathfindCount;
            this.spawnFillNanos = spawnFillNanos;
            this.spawnFillBatches = spawnFillBatches;
            this.spawnCandidateCount = spawnCandidateCount;
            this.pathSharedPublished = pathSharedPublished;
            this.pathSharedClaimed = pathSharedClaimed;
            this.tickNanosTotal = tickNanosTotal;
            this.tickCount = tickCount;
            this.trackerTaskNanos = trackerTaskNanos;
            this.trackerTaskCount = trackerTaskCount;
            this.trackerQueueSize = trackerQueueSize;
        }

        public double avgInterval() {
            return this.lastIntervalCount == 0L ? 0.0 : (double)this.lastIntervalSum / (double)this.lastIntervalCount;
        }

        public double avgPathfindMicros() {
            return this.pathfindCount == 0L ? 0.0 : (double)this.pathfindNanos / 1000.0 / (double)this.pathfindCount;
        }

        public double avgSpawnFillMillis() {
            return this.spawnFillBatches == 0L ? 0.0 : (double)this.spawnFillNanos / 1000000.0 / (double)this.spawnFillBatches;
        }

        public double avgTickMillis() {
            return this.tickCount == 0L ? 0.0 : (double)this.tickNanosTotal / 1000000.0 / (double)this.tickCount;
        }

        public double tps() {
            if (this.tickCount == 0L) {
                return 20.0;
            }
            double avgTickSeconds = (double)this.tickNanosTotal / 1.0E9 / (double)this.tickCount;
            if (avgTickSeconds <= 0.0) {
                return 20.0;
            }
            double tps = 1.0 / avgTickSeconds;
            return Math.min(20.0, tps);
        }

        public double avgTrackerTaskMillis() {
            return this.trackerTaskCount == 0L ? 0.0 : (double)this.trackerTaskNanos / 1000000.0 / (double)this.trackerTaskCount;
        }
    }
}

