/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.spawn;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;

public final class AsyncSpawnManager {
    private static volatile ExecutorService pool;
    private static final Map<Key, ArrayBlockingQueue<class_2338>> BUFFERS;
    private static final Map<Key, Long> LAST_SCHEDULE;
    private static final int BUFFER_CAPACITY = 64;
    private static final int FILL_BATCH = 32;
    private static final long RESCHEDULE_COOLDOWN_MS = 50L;

    private AsyncSpawnManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensurePool() {
        if (pool != null) return;
        Class<AsyncSpawnManager> clazz = AsyncSpawnManager.class;
        synchronized (AsyncSpawnManager.class) {
            if (pool != null) return;
            int threads = Math.max(1, WmbConfig.get().asyncSpawn.threadPoolSize);
            pool = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final AtomicInteger idx = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "WMB-AsyncSpawn-" + this.idx.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static class_2338 nextOrRandom(class_3218 level, class_2818 chunk) {
        if (!WmbConfig.get().asyncSpawn.enabled) {
            return AsyncSpawnManager.randomPosInChunk(level, chunk);
        }
        AsyncSpawnManager.ensurePool();
        Key key = Key.of(level, chunk.method_12004());
        ArrayBlockingQueue q = BUFFERS.computeIfAbsent(key, k -> new ArrayBlockingQueue(64));
        class_2338 polled = (class_2338)q.poll();
        if (polled != null) {
            return polled;
        }
        AsyncSpawnManager.maybeScheduleFill(level, chunk, q, key);
        return AsyncSpawnManager.randomPosInChunk(level, chunk);
    }

    private static void maybeScheduleFill(class_3218 level, class_2818 chunk, ArrayBlockingQueue<class_2338> q, Key key) {
        if (q.remainingCapacity() < 16) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = LAST_SCHEDULE.get(key);
        if (last != null && now - last < 50L) {
            return;
        }
        LAST_SCHEDULE.put(key, now);
        AsyncSpawnManager.ensurePool();
        pool.execute(() -> AsyncSpawnManager.fillPositions(level, chunk.method_12004(), q, 32));
    }

    private static void fillPositions(class_3218 level, class_1923 cp, ArrayBlockingQueue<class_2338> q, int count) {
        long nanos;
        boolean met = WmbConfig.get().metrics.enabled;
        long start = met ? System.nanoTime() : 0L;
        int minY = level.method_31607();
        int maxY = level.method_31600();
        int height = Math.max(1, maxY - minY);
        int x0 = cp.method_8326();
        int z0 = cp.method_8328();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        ArrayList<class_2338> local = new ArrayList<class_2338>(count);
        for (int i = 0; i < count; ++i) {
            int x = x0 + rnd.nextInt(16);
            int z = z0 + rnd.nextInt(16);
            int y = minY + rnd.nextInt(height);
            local.add(new class_2338(x, y, z));
        }
        for (class_2338 pos : local) {
            q.offer(pos);
        }
        if (met && (nanos = System.nanoTime() - start) > 0L) {
            Metrics.onAsyncSpawnFill(nanos, local.size());
        }
    }

    private static class_2338 randomPosInChunk(class_3218 level, class_2818 chunk) {
        class_1923 cp = chunk.method_12004();
        int minY = level.method_31607();
        int maxY = level.method_31600();
        int height = Math.max(1, maxY - minY);
        int x = cp.method_8326() + level.field_9229.method_43048(16);
        int z = cp.method_8328() + level.field_9229.method_43048(16);
        int y = minY + level.field_9229.method_43048(height);
        return new class_2338(x, y, z);
    }

    static {
        BUFFERS = new ConcurrentHashMap<Key, ArrayBlockingQueue<class_2338>>();
        LAST_SCHEDULE = new ConcurrentHashMap<Key, Long>();
    }

    private record Key(String dim, long chunkKey) {
        static Key of(class_3218 level, class_1923 cp) {
            return new Key(level.method_27983().method_29177().toString(), cp.method_8324());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.chunkKey == k.chunkKey && Objects.equals(this.dim, k.dim);
        }

        @Override
        public int hashCode() {
            return this.dim.hashCode() * 31 ^ Long.hashCode(this.chunkKey);
        }
    }
}

