/*
 * Decompiled with CFR 0.152.
 */
package com.bladelicious.screwsubanomalyone.procedures;

import com.bladelicious.screwsubanomalyone.ScrewSubanomalyoneMod;
import com.bladelicious.screwsubanomalyone.config.EntityRemovalConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber
public class DespawnHim {
    private static final Set<ResourceLocation> ENTITIES_TO_REMOVE = new HashSet<ResourceLocation>();
    private static boolean configLoaded = false;

    private static void loadConfig() {
        ENTITIES_TO_REMOVE.clear();
        try {
            for (String entityId : EntityRemovalConfig.getEntityList()) {
                try {
                    ResourceLocation resourceLocation = ResourceLocation.parse((String)entityId);
                    ENTITIES_TO_REMOVE.add(resourceLocation);
                    ScrewSubanomalyoneMod.LOGGER.debug("Added entity to removal list: {}", (Object)resourceLocation);
                }
                catch (Exception e) {
                    ScrewSubanomalyoneMod.LOGGER.error("Invalid entity ID in config: {}", (Object)entityId);
                }
            }
        }
        catch (Exception e) {
            ScrewSubanomalyoneMod.LOGGER.error("Error loading config", (Throwable)e);
        }
        configLoaded = true;
        ScrewSubanomalyoneMod.LOGGER.info("Loaded {} entities for removal", (Object)ENTITIES_TO_REMOVE.size());
    }

    public static void markConfigForReload() {
        configLoaded = false;
        ScrewSubanomalyoneMod.LOGGER.info("Config marked for reload");
    }

    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        if (!configLoaded) {
            DespawnHim.loadConfig();
        }
        if (ENTITIES_TO_REMOVE.isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        ResourceLocation entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (entityType != null && ENTITIES_TO_REMOVE.contains(entityType)) {
            if (((Boolean)EntityRemovalConfig.SPEC.enableLogging.get()).booleanValue()) {
                String message = String.format((String)EntityRemovalConfig.SPEC.logMessage.get(), entityType.toString());
                ScrewSubanomalyoneMod.LOGGER.info(message);
            }
            entity.discard();
            event.setCanceled(true);
        }
    }
}

