/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.bottle_ship.content.item;

import com.forgestove.bottle_ship.BottleShip;
import com.forgestove.bottle_ship.content.Registry;
import com.forgestove.bottle_ship.content.util.BottleItemHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class BottleWithShipItem
extends Item {
    public BottleWithShipItem(@NotNull Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public void m_7373_(@NotNull ItemStack itemStack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (level == null) {
            return;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return;
        }
        tooltip.add((Component)BottleItemHelper.translate("tooltip.%s.id".formatted("bottle_ship"), BottleItemHelper.literal("\u00a7b%s\u00a7f".formatted(nbt.m_128461_("ID")))));
        tooltip.add((Component)BottleItemHelper.translate("tooltip.%s.name".formatted("bottle_ship"), BottleItemHelper.literal("\u00a7b%s\u00a7f".formatted(nbt.m_128461_("Name")))));
        tooltip.add((Component)BottleItemHelper.translate("tooltip.%s.size".formatted("bottle_ship"), BottleItemHelper.literal(nbt.m_128461_("Size"))));
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        return InteractionResult.PASS;
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack itemStack, int tickLeft) {
        ServerPlayer player = BottleItemHelper.getPlayer(level, livingEntity, BottleShip.CONFIG.bottleWithShip.chargeTime);
        if (player == null) {
            return;
        }
        BottleItemHelper.showProgress(BottleShip.CONFIG.bottleWithShip.chargeTime, (Player)player);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack currentStack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)currentStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)currentStack);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tickLeft) {
        if (level.m_5776_()) {
            return;
        }
        int tickCount = this.m_8105_(itemStack) - tickLeft;
        if (tickCount < BottleShip.CONFIG.bottleWithShip.chargeTime) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack newStack = new ItemStack((ItemLike)Registry.BOTTLE_WITHOUT_SHIP.get());
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            player.m_21008_(player.m_7655_(), newStack);
            return;
        }
        ServerShip ship = this.getShipFromNBT(nbt, level);
        if (ship == null) {
            player.m_21008_(player.m_7655_(), newStack);
            return;
        }
        double strength = (double)tickCount / 20.0 * (double)BottleShip.CONFIG.bottleWithShip.chargeStrength;
        this.releaseShipAtTarget((ServerLevel)level, player, ship, strength);
        BottleItemHelper.setItem(itemStack, level, player, newStack, BottleShip.CONFIG.bottleWithShip.cooldown, SoundEvents.f_11769_);
    }

    @Nullable
    private ServerShip getShipFromNBT(@NotNull CompoundTag nbt, @NotNull Level level) {
        try {
            long shipID = Long.parseLong(nbt.m_128461_("ID"));
            MinecraftServer server = level.m_7654_();
            if (server == null) {
                return null;
            }
            return (ServerShip)VSGameUtilsKt.getVsPipeline((MinecraftServer)server).getShipWorld().getAllShips().getById(shipID);
        }
        catch (NumberFormatException e) {
            BottleShip.LOGGER.error("Failed to parse ship ID from bottle NBT", (Throwable)e);
            return null;
        }
    }

    private void releaseShipAtTarget(@NotNull ServerLevel level, @NotNull Player player, @NotNull ServerShip ship, double strength) {
        Vec3 direction = BottleItemHelper.getPlayerLookDirection(player);
        AABBic shipAABB = ship.getShipAABB();
        if (shipAABB == null) {
            return;
        }
        AABBdc worldAABB = ship.getWorldAABB();
        double depth = (worldAABB.maxY() - worldAABB.minY()) / 2.0;
        double massHeight = ship.getInertiaData().getCenterOfMassInShip().y() - (double)shipAABB.minY();
        Vec3 playerPos = player.m_20182_();
        double targetX = playerPos.f_82479_ + direction.f_82479_ * (strength + depth);
        double targetY = playerPos.f_82480_ + direction.f_82480_ * (strength + massHeight);
        double targetZ = playerPos.f_82481_ + direction.f_82481_ * (strength + depth);
        BottleItemHelper.teleportShip(level, ship, targetX, targetY, targetZ);
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 72000;
    }
}

