/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.bottle_ship.content.item;

import com.forgestove.bottle_ship.BottleShip;
import com.forgestove.bottle_ship.content.Registry;
import com.forgestove.bottle_ship.content.util.BottleItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class BottleWithoutShipItem
extends Item {
    public ServerShip ship;

    public BottleWithoutShipItem(@NotNull Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null || player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        this.ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)level), (BlockPos)context.m_8083_());
        if (this.ship == null) {
            return InteractionResult.FAIL;
        }
        player.m_6672_(context.m_43724_());
        return InteractionResult.CONSUME;
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack itemStack, int tickLeft) {
        ServerPlayer player = BottleItemHelper.getPlayer(level, livingEntity, BottleShip.CONFIG.bottleWithoutShip.chargeTime);
        if (player == null) {
            return;
        }
        ServerShip targetShip = BottleItemHelper.getTargetShip((ServerLevel)level, (Player)player);
        if (this.ship == null || !this.ship.equals(targetShip)) {
            player.m_5810_();
            player.m_5661_((Component)Component.m_237113_((String)""), true);
            return;
        }
        BottleItemHelper.showProgress(BottleShip.CONFIG.bottleWithoutShip.chargeTime, (Player)player);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tickLeft) {
        if (level.m_5776_()) {
            return;
        }
        if (this.m_8105_(itemStack) - tickLeft < BottleShip.CONFIG.bottleWithoutShip.chargeTime) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        this.ship = BottleItemHelper.getTargetShip((ServerLevel)level, player);
        if (this.ship == null) {
            return;
        }
        AABBdc worldAABB = this.ship.getWorldAABB();
        AABB area = new AABB(worldAABB.minX(), worldAABB.minY(), worldAABB.minZ(), worldAABB.maxX(), worldAABB.maxY(), worldAABB.maxZ());
        level.m_45933_(null, area).stream().filter(entity -> entity instanceof Player).forEach(Entity::m_8127_);
        Vector3dc position = this.ship.getTransform().getPositionInShip();
        BottleItemHelper.teleportShip((ServerLevel)level, this.ship, -position.x(), position.y(), -position.z());
        ItemStack newStack = this.createBottleWithShip(this.ship);
        BottleItemHelper.setItem(itemStack, level, player, newStack, BottleShip.CONFIG.bottleWithoutShip.cooldown, SoundEvents.f_11770_);
    }

    private ItemStack createBottleWithShip(@NotNull ServerShip ship) {
        AABBic shipAABB;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ID", String.valueOf(ship.getId()));
        if (ship.getSlug() != null) {
            nbt.m_128359_("Name", ship.getSlug());
        }
        if ((shipAABB = ship.getShipAABB()) != null) {
            nbt.m_128359_("Size", "[\u00a7bX:\u00a7a%d \u00a7bY:\u00a7a%d \u00a7bZ:\u00a7a%d\u00a7f]".formatted(shipAABB.maxX() - shipAABB.minX(), shipAABB.maxY() - shipAABB.minY(), shipAABB.maxZ() - shipAABB.minZ()));
        }
        ItemStack newStack = new ItemStack((ItemLike)Registry.BOTTLE_WITH_SHIP.get());
        newStack.m_41751_(nbt);
        return newStack;
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 72000;
    }
}

