/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.bottle_ship.content.util;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.TeleportShipWithConnectedKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class BottleItemHelper {
    public static void teleportShip(@NotNull ServerLevel level, @NotNull ServerShip ship, double x, double y, double z) {
        Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
        TeleportShipWithConnectedKt.teleportShipWithConnected((ServerLevel)level, (ServerShip)ship, (Vector3d)new Vector3d((Number)x, (Number)y, (Number)z), (Quaterniondc)ship.getTransform().getShipToWorldRotation(), (Double)((scaling.x() + scaling.y() + scaling.z()) / 3.0), (String)VSGameUtilsKt.getDimensionId((Level)level));
    }

    public static void setItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player, @NotNull ItemStack newStack, int configValue, SoundEvent soundEvent) {
        player.m_36335_().m_41524_(newStack.m_41720_(), configValue);
        if (itemStack.m_41613_() != 1) {
            itemStack.m_41774_(1);
            player.m_36356_(newStack);
        } else {
            player.m_21008_(player.m_7655_(), newStack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableComponent translate(@NotNull String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableComponent literal(@NotNull String text) {
        return Component.m_237113_((String)text);
    }

    @Nullable
    public static ServerPlayer getPlayer(@NotNull Level level, @NotNull LivingEntity livingEntity, int chargeTime) {
        if (level.m_5776_() || !(livingEntity instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (chargeTime != 0) {
            return player;
        }
        player.m_21253_();
        return null;
    }

    public static void showProgress(int chargeTime, @NotNull Player player) {
        int progress = player.m_21252_() * 20 / chargeTime;
        StringBuilder progressBar = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            if (i < progress) {
                progressBar.append("\u00a7a\u25a0");
                continue;
            }
            progressBar.append("\u00a7c\u25a0");
        }
        player.m_5661_((Component)Component.m_237113_((String)progressBar.toString()), true);
    }

    @Nullable
    public static ServerShip getTargetShip(@NotNull ServerLevel level, @NotNull Player player) {
        BlockHitResult hitResult = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(player.getBlockReach())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)hitResult.m_82425_());
    }

    public static Vec3 getPlayerLookDirection(@NotNull Player player) {
        double yaw = Math.toRadians(player.m_146908_());
        double pitch = Math.toRadians(player.m_146909_());
        double dx = -Math.sin(yaw) * Math.cos(pitch);
        double dy = -Math.sin(pitch);
        double dz = Math.cos(yaw) * Math.cos(pitch);
        return new Vec3(dx, dy, dz);
    }
}

