/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.misc.structurepiececounter;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsObj;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6328;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends class_4309<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final Codec<JsonElement> JSON_ELEMENT_CODEC = Codec.PASSTHROUGH.xmap(dyn -> (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue(), je -> new Dynamic((DynamicOps)JsonOps.INSTANCE, je));
    private static final class_7654 FILES = new class_7654("rs_pieces_spawn_counts", ".json");
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<class_2960, List<StructurePieceCountsObj>> structureToPieceCountsObjs = new HashMap<class_2960, List<StructurePieceCountsObj>>();
    private final Map<class_2960, Map<class_2960, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<class_2960, Map<class_2960, RequiredPieceNeeds>>();
    private final Map<class_2960, Map<class_2960, Integer>> cachedMaxCountPiecesMap = new HashMap<class_2960, Map<class_2960, Integer>>();

    public StructurePieceCountsManager() {
        super(JSON_ELEMENT_CODEC, FILES);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 resourceManager, class_3695 profiler) {
        HashMap<class_2960, List<StructurePieceCountsObj>> mapBuilder = new HashMap<class_2960, List<StructurePieceCountsObj>>();
        prepared.forEach((fileId, jsonElement) -> {
            try {
                mapBuilder.put((class_2960)fileId, this.getStructurePieceCountsObjs((class_2960)fileId, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", fileId, jsonElement, (Object)e);
            }
        });
        this.structureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        this.cachedMaxCountPiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(resourceManager);
    }

    @class_6328
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(class_2960 fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(this){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany == null || entry.neverSpawnMoreThanThisMany == null || entry.alwaysSpawnThisMany <= entry.neverSpawnMoreThanThisMany) continue;
            throw new Exception("Moog's Structure Lib Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
        }
        return piecesSpawnCounts;
    }

    public void parseAndAddCountsJSONObj(class_2960 structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.structureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<class_2960, RequiredPieceNeeds> getRequirePieces(class_2960 structureRL) {
        if (!this.structureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<class_2960, RequiredPieceNeeds> requirePiecesMap = new HashMap<class_2960, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.alwaysSpawnThisMany == null) continue;
                requirePiecesMap.put(class_2960.method_12829((String)entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
            }
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @class_6328
    public Map<class_2960, Integer> getMaximumCountForPieces(class_2960 structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<class_2960, Integer> maxCountPiecesMap = new HashMap<class_2960, Integer>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.neverSpawnMoreThanThisMany == null) continue;
                maxCountPiecesMap.put(class_2960.method_12829((String)entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
            }
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

