/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.world.structures.placements;

import com.finndog.moogs_structures.modinit.MoogsStructuresStructurePlacementType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7059;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class AdvancedRandomSpread
extends class_6872 {
    public static final MapCodec<AdvancedRandomSpread> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41646()), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AdvancedRandomSpread::superExclusionZone), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spacing").forGetter(AdvancedRandomSpread::method_41632), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("separation").forGetter(AdvancedRandomSpread::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(AdvancedRandomSpread::method_41634), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("min_distance_from_world_origin").forGetter(AdvancedRandomSpread::minDistanceFromWorldOrigin)).apply((Applicative)instance, instance.stable(AdvancedRandomSpread::new)));
    private final int spacing;
    private final int separation;
    private final class_6873 spreadType;
    private final Optional<Integer> minDistanceFromWorldOrigin;
    private final Optional<SuperExclusionZone> superExclusionZone;

    public AdvancedRandomSpread(class_2382 locationOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, Optional<class_6874.class_7152> exclusionZone, Optional<SuperExclusionZone> superExclusionZone, int spacing, int separation, class_6873 spreadType, Optional<Integer> minDistanceFromWorldOrigin) {
        super(locationOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.spacing = (int)Math.round((double)spacing * 1.65);
        this.separation = (int)Math.round((double)separation * 1.65);
        this.spreadType = spreadType;
        this.minDistanceFromWorldOrigin = minDistanceFromWorldOrigin;
        this.superExclusionZone = superExclusionZone;
        if (spacing <= separation) {
            throw new RuntimeException("    Moog's Structure Lib: Spacing cannot be less or equal to separation.\n    Please correct this error as there's no way to spawn this structure properly\n        Spacing: %s\n        Separation: %s.\n".formatted(spacing, separation));
        }
    }

    public int method_41632() {
        return this.spacing;
    }

    public int method_41633() {
        return this.separation;
    }

    public class_6873 method_41634() {
        return this.spreadType;
    }

    public Optional<Integer> minDistanceFromWorldOrigin() {
        return this.minDistanceFromWorldOrigin;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public boolean method_41639(class_7869 chunkGeneratorStructureState, int i, int j) {
        if (!super.method_41639(chunkGeneratorStructureState, i, j)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(chunkGeneratorStructureState, i, j);
    }

    public class_1923 method_40169(long seed, int x, int z) {
        int regionX = Math.floorDiv(x, this.spacing);
        int regionZ = Math.floorDiv(z, this.spacing);
        class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(0L));
        worldgenrandom.method_12665(seed, regionX, regionZ, this.method_41645());
        int diff = this.spacing - this.separation;
        int offsetX = this.spreadType.method_40173((class_5819)worldgenrandom, diff);
        int offsetZ = this.spreadType.method_40173((class_5819)worldgenrandom, diff);
        return new class_1923(regionX * this.spacing + offsetX, regionZ * this.spacing + offsetZ);
    }

    protected boolean method_40168(class_7869 chunkGeneratorStructureState, int x, int z) {
        int zBlockPos;
        int xBlockPos;
        if (this.minDistanceFromWorldOrigin.isPresent() && (xBlockPos = x * 16) * xBlockPos + (zBlockPos = z * 16) * zBlockPos < this.minDistanceFromWorldOrigin.get() * this.minDistanceFromWorldOrigin.get()) {
            return false;
        }
        class_1923 chunkpos = this.method_40169(chunkGeneratorStructureState.method_46714(), x, z);
        return chunkpos.field_9181 == x && chunkpos.field_9180 == z;
    }

    public class_6875<?> method_40166() {
        return MoogsStructuresStructurePlacementType.ADVANCED_RANDOM_SPREAD.get();
    }

    public record SuperExclusionZone(class_6885<class_7059> otherSet, int chunkCount, Optional<Integer> allowedChunkCount) {
        private static final ThreadLocal<Set<class_2960>> EVALUATING_SETS = ThreadLocal.withInitial(HashSet::new);
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_6895.method_40341((class_5321)class_7924.field_41248, (Codec)class_7059.field_37195).fieldOf("other_set").forGetter(SuperExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("chunk_count").forGetter(SuperExclusionZone::chunkCount), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("allowed_chunk_count").forGetter(SuperExclusionZone::allowedChunkCount)).apply((Applicative)builder, SuperExclusionZone::new));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isPlacementForbidden(class_7869 chunkGeneratorStructureState, int l, int j) {
            Set<class_2960> evaluating = EVALUATING_SETS.get();
            for (class_6880 holder : this.otherSet) {
                class_2960 setId = holder.method_40230().map(key -> key.method_29177()).orElse(null);
                if (setId == null || evaluating.contains(setId)) continue;
                evaluating.add(setId);
                try {
                    if (!chunkGeneratorStructureState.method_46709(holder, l, j, this.chunkCount)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    evaluating.remove(setId);
                }
            }
            if (this.allowedChunkCount.isPresent() && this.allowedChunkCount.get() > this.chunkCount) {
                boolean isAnyInRange = false;
                for (class_6880 holder : this.otherSet) {
                    class_2960 setId = holder.method_40230().map(key -> key.method_29177()).orElse(null);
                    if (setId == null || evaluating.contains(setId)) continue;
                    evaluating.add(setId);
                    try {
                        if (!chunkGeneratorStructureState.method_46709(holder, l, j, this.allowedChunkCount.get().intValue())) continue;
                        isAnyInRange = true;
                    }
                    finally {
                        evaluating.remove(setId);
                    }
                }
                if (!isAnyInRange) {
                    return false;
                }
            }
            return false;
        }
    }
}

