/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.misc.structurepiececounter;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsObj;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final Codec<JsonElement> JSON_ELEMENT_CODEC = Codec.PASSTHROUGH.xmap(dyn -> (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue(), je -> new Dynamic((DynamicOps)JsonOps.INSTANCE, je));
    private static final FileToIdConverter FILES = new FileToIdConverter("rs_pieces_spawn_counts", ".json");
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<ResourceLocation, List<StructurePieceCountsObj>> structureToPieceCountsObjs = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
    private final Map<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>>();
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> cachedMaxCountPiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public StructurePieceCountsManager() {
        super(JSON_ELEMENT_CODEC, FILES);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, List<StructurePieceCountsObj>> mapBuilder = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
        prepared.forEach((fileId, jsonElement) -> {
            try {
                mapBuilder.put((ResourceLocation)fileId, this.getStructurePieceCountsObjs((ResourceLocation)fileId, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", fileId, jsonElement, (Object)e);
            }
        });
        this.structureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        this.cachedMaxCountPiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(resourceManager);
    }

    @MethodsReturnNonnullByDefault
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(ResourceLocation fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(this){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany == null || entry.neverSpawnMoreThanThisMany == null || entry.alwaysSpawnThisMany <= entry.neverSpawnMoreThanThisMany) continue;
            throw new Exception("Moog's Structure Lib Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
        }
        return piecesSpawnCounts;
    }

    public void parseAndAddCountsJSONObj(ResourceLocation structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.structureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<ResourceLocation, RequiredPieceNeeds> getRequirePieces(ResourceLocation structureRL) {
        if (!this.structureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, RequiredPieceNeeds> requirePiecesMap = new HashMap<ResourceLocation, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.alwaysSpawnThisMany == null) continue;
                requirePiecesMap.put(ResourceLocation.tryParse((String)entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
            }
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @MethodsReturnNonnullByDefault
    public Map<ResourceLocation, Integer> getMaximumCountForPieces(ResourceLocation structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, Integer> maxCountPiecesMap = new HashMap<ResourceLocation, Integer>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.neverSpawnMoreThanThisMany == null) continue;
                maxCountPiecesMap.put(ResourceLocation.tryParse((String)entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
            }
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

