/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.utils;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3748;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;

public final class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<class_2680, Boolean>();

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, class_5819 random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.method_43057() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_1922 world, class_2338 pos, class_2680 state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> class_2248.method_9614((class_265)stateIn.method_26201(world, pos)));
    }

    public static class_1799 enchantRandomly(class_5455 registryAccess, class_5819 random, class_1799 itemToEnchant, float chance) {
        List<class_6880.class_6883> list;
        if (random.method_43057() < chance && !(list = registryAccess.method_30530(class_7924.field_41265).method_40270().filter(holder -> ((class_1887)holder.comp_349()).method_8192(itemToEnchant)).toList()).isEmpty()) {
            class_6880.class_6883 enchantment = list.get(random.method_43048(list.size()));
            int enchantmentLevel = random.method_43048(class_3532.method_15395((class_5819)random, (int)((class_1887)enchantment.comp_349()).method_8187(), (int)((class_1887)enchantment.comp_349()).method_8183()) + 1);
            itemToEnchant.method_7978((class_6880)enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static class_2338 getHighestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        while (mutable.method_10264() > chunkGenerator.method_16398()) {
            class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
            if (!currentBlockstate.method_26225()) {
                mutable.method_10098(class_2350.field_11033);
                continue;
            }
            if (blockView.method_32892(mutable.method_10264() + 3).method_26215() && (canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225())) {
                return mutable;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable;
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_16398() + 1, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225()) && blockView.method_32892(mutable.method_10264() + 1).method_26215() && blockView.method_32892(mutable.method_10264() + 5).method_26215()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable.method_10103(mutable.method_10263(), chunkGenerator.method_16398(), mutable.method_10260());
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || !blockState.method_26227().method_15769() || blockState.method_26164(class_3481.field_44470);
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_3501 jigsaw1, class_3499.class_3501 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.comp_1342().method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.comp_1342().method_11654((class_2769)class_3748.field_23262);
        String joint = jigsaw1.comp_1343().method_10558("joint");
        if (joint.isEmpty()) {
            joint = prop1.method_26426().method_10166().method_10179() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.method_26426() == prop2.method_26426().method_10153() && (isRollable || prop1.method_26428() == prop2.method_26428()) && jigsaw1.comp_1343().method_10558("target").equals(jigsaw2.comp_1343().method_10558("name"));
    }

    public static Map<class_2960, List<JsonElement>> getAllDatapacksJSONElement(class_3300 resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<class_2960, List<JsonElement>> map = new HashMap<class_2960, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.method_41265(dataType, fileString -> fileString.toString().endsWith(".json")).entrySet()) {
            String identifierPath = ((class_2960)resourceStackEntry.getKey()).method_12832();
            class_2960 fileID = class_2960.method_60655((String)((class_2960)resourceStackEntry.getKey()).method_12836(), (String)identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (class_3298 resource : (List)resourceStackEntry.getValue()) {
                    InputStream fileStream = resource.method_14482();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        MoogsStructuresCommon.LOGGER.error("(Moog's Structure Lib {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, resourceStackEntry);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                MoogsStructuresCommon.LOGGER.error("(Moog's Structure Lib {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }
}

