/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.commands;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.finndog.moogs_structures.utils.DebugFlags;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class DebugCommand {
    private DebugCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"moogs_structures").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").executes(context -> DebugCommand.toggle((CommandSourceStack)context.getSource()))).then(Commands.m_82127_((String)"on").executes(context -> DebugCommand.set((CommandSourceStack)context.getSource(), true)))).then(Commands.m_82127_((String)"off").executes(context -> DebugCommand.set((CommandSourceStack)context.getSource(), false)))).then(Commands.m_82127_((String)"status").executes(context -> DebugCommand.report((CommandSourceStack)context.getSource())))));
    }

    private static int toggle(CommandSourceStack source) {
        boolean enabled = DebugFlags.toggle();
        return DebugCommand.notify(source, "toggled", enabled);
    }

    private static int set(CommandSourceStack source, boolean value) {
        boolean enabled = DebugFlags.setEnabled(value);
        return DebugCommand.notify(source, value ? "enabled" : "disabled", enabled);
    }

    private static int report(CommandSourceStack source) {
        boolean enabled = DebugFlags.isEnabled();
        source.m_288197_(() -> Component.m_237113_((String)("Moog's Structure debug mode is " + (enabled ? "enabled" : "disabled"))), false);
        return enabled ? 1 : 0;
    }

    private static int notify(CommandSourceStack source, String action, boolean enabled) {
        String message = "Moog's Structure debug mode " + action + " (" + (enabled ? "enabled" : "disabled") + ")";
        MoogsStructuresCommon.LOGGER.info(message);
        source.m_288197_(() -> Component.m_237113_((String)message), true);
        return enabled ? 1 : 0;
    }
}

