/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights;

import com.j9studios.dragonights.abilities.CorruptedLefontiAbilities;
import com.j9studios.dragonights.abilities.LefontiAbilities;
import com.j9studios.dragonights.events.common.FirstJoinMessages;
import com.j9studios.dragonights.events.items.AxeOozeHandler;
import com.j9studios.dragonights.registry.ModBlocks;
import com.j9studios.dragonights.registry.ModCreativeTabs;
import com.j9studios.dragonights.registry.ModEntityBlocks;
import com.j9studios.dragonights.registry.ModGameRules;
import com.j9studios.dragonights.registry.ModItems;
import com.j9studios.dragonights.registry.ModParticleTypes;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;

@Mod(value="dragonights")
public class DragonightsMod {
    public static final String MODID = "dragonights";
    private static final Logger LOGGER = LogUtils.getLogger();

    public DragonightsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::onClientSetup);
        ModBlocks.register(modEventBus);
        ModEntityBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModParticleTypes.register(modEventBus);
        ModGameRules.register();
        LefontiAbilities.register();
        CorruptedLefontiAbilities.register();
        NeoForge.EVENT_BUS.addListener(AxeOozeHandler::onRightClickBlock);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register(FirstJoinMessages.class);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
    }
}

