/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DragoniteTickAbility {
    private static final TagKey<EntityType<?>> ENDER_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.tryParse((String)"c:enders"));

    public boolean preCheck(ServerLevel level, BlockPos pos, BlockState state, String sourceType, Player player) {
        boolean blocked;
        boolean inEnd = level.dimension() == Level.END;
        boolean threatNearby = this.hasNearbyThreat(level, pos, sourceType, player);
        boolean bl = blocked = (inEnd || threatNearby) && player != null && !player.isUnderWater();
        if (blocked) {
            BlockPos centerPos = pos;
            level.playSound(null, centerPos, SoundEvents.ENDERMAN_AMBIENT, SoundSource.PLAYERS, 0.5f, 1.0f + level.random.nextFloat());
            for (int i = 0; i < 8; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 1.0;
                double offsetY = level.random.nextDouble();
                double offsetZ = (level.random.nextDouble() - 0.5) * 1.0;
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)centerPos.getX() + 0.5 + offsetX, (double)centerPos.getY() + 0.5 + offsetY, (double)centerPos.getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return blocked;
    }

    public void execute(ServerLevel level, BlockPos pos, BlockState state, String sourceType, Player player) {
        boolean isBlock = "block".equals(sourceType) && state != null;
        BooleanProperty ACTIVE = null;
        if (isBlock) {
            Block block = state.getBlock();
            ACTIVE = (BooleanProperty)block.getStateDefinition().getProperty("active");
            BlockPos[] DISABLED = (BlockPos[])block.getStateDefinition().getProperty("disabled");
            if (ACTIVE == null || DISABLED == null) {
                isBlock = false;
            }
        }
        boolean isUnderwater = false;
        for (BlockPos side : new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()}) {
            if (!level.getFluidState(side).is(FluidTags.WATER)) continue;
            isUnderwater = true;
            break;
        }
        boolean inEnd = level.dimension() == Level.END;
        boolean threatNearby = this.hasNearbyThreat(level, pos, sourceType, player);
        if (isBlock) {
            boolean shouldBeActive;
            boolean bl = shouldBeActive = !inEnd && !threatNearby && isUnderwater;
            if ((Boolean)state.getValue((Property)ACTIVE) != shouldBeActive) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive)), 3);
            }
        }
    }

    private boolean hasNearbyThreat(ServerLevel level, BlockPos pos, String sourceType, Player player) {
        if ("item".equals(sourceType) || "ability".equals(sourceType)) {
            if (player != null) {
                return !level.getEntitiesOfClass(Entity.class, player.getBoundingBox().inflate(8.0), entity -> entity.getType().is(ENDER_TAG)).isEmpty();
            }
            return false;
        }
        return !level.getEntitiesOfClass(Entity.class, new AABB(pos).inflate(8.0), entity -> entity.getType().is(ENDER_TAG)).isEmpty();
    }
}

