/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities.corrupted_lefonti;

import com.j9studios.dragonights.abilities.CorruptedLefontiAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CorruptedLefontiDecayAbility
implements CorruptedLefontiAbility {
    private static final int DEFAULT_RADIUS = 1;

    @Override
    public void perform(ServerLevel level, BlockPos centerPos, BlockState state, RandomSource random, String sourceType, Player player, ItemStack handStack) {
        if (level.isClientSide()) {
            return;
        }
        if (state.is(BlockTags.LOGS)) {
            this.decayTree(level, centerPos, 20, 1);
            this.playDecaySound(level, centerPos, 2.0f);
            this.damageItem(sourceType, player, handStack);
            return;
        }
        int radius = CorruptedLefontiDecayAbility.isDecayable(state) ? 0 : (state.is(BlockTags.DIRT) ? 4 : 1);
        int particleCount = Math.max(10, radius > 0 ? radius * radius * 2 : 1);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > radius * radius) continue;
                for (int dy = -2; dy <= 2; ++dy) {
                    BlockPos checkPos = centerPos.offset(dx, dy, dz);
                    BlockState checkState = level.getBlockState(checkPos);
                    if (!CorruptedLefontiDecayAbility.isDecayable(checkState)) continue;
                    this.destroyBlock(level, checkPos, particleCount);
                }
            }
        }
        this.playDecaySound(level, centerPos, Math.max(1.0f, (float)radius / 5.0f));
        this.damageItem(sourceType, player, handStack);
    }

    public static boolean isDecayable(BlockState state) {
        return state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS) || state.is(BlockTags.LEAVES) || state.is(Blocks.SHORT_GRASS) || state.is(Blocks.TALL_GRASS) || state.is(Blocks.VINE) || state.is(Blocks.FERN) || state.is(Blocks.BUSH) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.GLOW_LICHEN) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS) || state.is(Blocks.LILY_PAD);
    }

    private void destroyBlock(ServerLevel level, BlockPos pos, int particleCount) {
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.TALL_GRASS) || state.is(Blocks.TALL_SEAGRASS)) {
            BlockPos upper = pos.above();
            BlockPos lower = pos.below();
            if (level.getBlockState(upper).getBlock() == state.getBlock()) {
                level.destroyBlock(upper, false);
                this.spawnParticles(level, upper, particleCount);
            }
            if (level.getBlockState(lower).getBlock() == state.getBlock()) {
                level.destroyBlock(lower, false);
                this.spawnParticles(level, lower, particleCount);
            }
        }
        level.destroyBlock(pos, false);
        this.spawnParticles(level, pos, particleCount);
    }

    private void spawnParticles(ServerLevel level, BlockPos pos, int particleCount) {
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, particleCount, 0.25, 0.25, 0.25, 0.05);
    }

    private void playDecaySound(ServerLevel level, BlockPos pos, float volume) {
        level.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, volume, 1.0f);
    }

    private void damageItem(String sourceType, Player player, ItemStack handStack) {
        if ("item".equals(sourceType) && player != null && handStack != null) {
            if (handStack.isDamageableItem()) {
                handStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            } else {
                handStack.shrink(1);
            }
        }
    }

    private void decayTree(ServerLevel level, BlockPos centerPos, int particleCount, int radius) {
        int decayTreeRadius = radius * 2 + 1;
        for (int dx = -decayTreeRadius; dx <= decayTreeRadius; ++dx) {
            for (int dz = -decayTreeRadius; dz <= decayTreeRadius; ++dz) {
                if (dx * dx + dz * dz > decayTreeRadius * decayTreeRadius) continue;
                for (int dy = -decayTreeRadius; dy <= decayTreeRadius; ++dy) {
                    BlockPos checkPos = centerPos.offset(dx, dy, dz);
                    BlockState checkState = level.getBlockState(checkPos);
                    if (!checkState.is(BlockTags.LEAVES) && !checkState.is(Blocks.VINE)) continue;
                    this.destroyBlock(level, checkPos, particleCount);
                }
            }
        }
    }

    public static boolean externalCheck(ServerLevel level, BlockPos centerPos, boolean isLogClick, int radius) {
        BlockState centerState = level.getBlockState(centerPos);
        if (centerState.is(BlockTags.DIRT) || centerState.is(Blocks.FARMLAND)) {
            int effectiveRadius = radius;
            for (int dx = -effectiveRadius; dx <= effectiveRadius; ++dx) {
                for (int dz = -effectiveRadius; dz <= effectiveRadius; ++dz) {
                    if (dx * dx + dz * dz > effectiveRadius * effectiveRadius) continue;
                    for (int dy = -2; dy <= 2; ++dy) {
                        BlockPos checkPos = centerPos.offset(dx, dy, dz);
                        BlockState checkState = level.getBlockState(checkPos);
                        if (!CorruptedLefontiDecayAbility.isDecayable(checkState)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (centerState.is(BlockTags.LOGS)) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos checkPos;
                        BlockState checkState;
                        if (dx == 0 && dy == 0 && dz == 0 || !(checkState = level.getBlockState(checkPos = centerPos.offset(dx, dy, dz))).is(BlockTags.LEAVES) && !checkState.is(Blocks.VINE)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

