/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities.lefonti;

import com.j9studios.dragonights.abilities.LefontiAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LefontiBonemealAbility
implements LefontiAbility {
    private static final int DEFAULT_RADIUS = 1;

    @Override
    public void perform(ServerLevel level, BlockPos centerPos, BlockState state, RandomSource random, String sourceType, Player player, ItemStack handStack) {
        int radius = 1;
        boolean isSolid = state.canOcclude();
        int particleCount = Math.max(10, radius * radius * 20);
        if (isSolid) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BonemealableBlock growable;
                    BlockPos pos;
                    BlockState blockState;
                    Block block;
                    if (dx * dx + dz * dz > radius * radius || !((block = (blockState = level.getBlockState(pos = centerPos.offset(dx, 0, dz))).getBlock()) instanceof BonemealableBlock) || !(growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, blockState)) continue;
                    growable.performBonemeal(level, random, pos, blockState);
                    level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, particleCount, 1.25, 0.25, 1.25, 0.05);
                }
            }
        } else {
            BonemealableBlock growable;
            BlockState blockState = level.getBlockState(centerPos);
            Block block = blockState.getBlock();
            if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, centerPos, blockState)) {
                growable.performBonemeal(level, random, centerPos, blockState);
                level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)centerPos.getX() + 0.5, (double)centerPos.getY() + 0.5, (double)centerPos.getZ() + 0.5, 10, 0.25, 0.25, 0.25, 0.05);
            }
        }
        float soundVolume = Math.max(1.0f, (float)radius / 5.0f);
        level.playSound(null, centerPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, soundVolume, 1.0f);
        if ("item".equals(sourceType) && player != null && handStack != null) {
            if (handStack.isDamageableItem()) {
                handStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            } else {
                handStack.shrink(1);
            }
        }
    }
}

