/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.blocks;

import com.j9studios.dragonights.events.blocks.CorruptedLefontiBlockEvents;
import com.j9studios.dragonights.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CorruptedLefontiBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty DISABLED = BooleanProperty.create((String)"disabled");
    public static final IntegerProperty TICK_COUNT = IntegerProperty.create((String)"tick_count", (int)0, (int)8);
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)1, (int)5);

    public CorruptedLefontiBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)TICK_COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, DISABLED, TICK_COUNT, STAGE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        CorruptedLefontiBlockEvents.handleTick(this, state, level, pos);
        level.scheduleTick(pos, (Block)this, 1);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        CorruptedLefontiBlockEvents.handleRandomTick(this, state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.is(ModBlocks.CHONDRITE_LEFONTI_ORE) && !world.isClientSide && !player.isCreative() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            int xp = 3 + world.random.nextInt(5);
            this.popExperience(serverWorld, pos, xp);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }
}

