/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.events.blocks;

import com.j9studios.dragonights.abilities.CorruptedLefontiAbilities;
import com.j9studios.dragonights.registry.ModBlocks;
import com.j9studios.dragonights.registry.ModGameRules;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;

public class CorruptedLefontiBlockEvents {
    public static final TagKey<Block> DIRT = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"minecraft:dirt"));
    public static final ResourceKey<DamageType> MAGIC_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.tryParse((String)"minecraft:magic"));
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_3_TAGS = new HashMap<TagKey<Block>, Block>();

    public static void spreadSculk(ServerLevel level, BlockPos center, int radius, RandomSource random) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos targetPos;
                    BlockState targetState;
                    double distanceSq = dx * dx + dy * dy + dz * dz;
                    if (distanceSq > (double)(radius * radius) || !(targetState = level.getBlockState(targetPos = center.offset(dx, dy, dz))).is(BlockTags.SCULK_REPLACEABLE) || !(random.nextDouble() < 0.3)) continue;
                    level.setBlock(targetPos, Blocks.SCULK.defaultBlockState(), 3);
                    level.sendParticles((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5, 1, 0.2, 0.2, 0.2, 0.05);
                }
            }
        }
    }

    public static void handleTick(Block block, BlockState state, ServerLevel level, BlockPos pos) {
        boolean shouldBeActive;
        BooleanProperty ACTIVE = (BooleanProperty)block.getStateDefinition().getProperty("active");
        BooleanProperty DISABLED = (BooleanProperty)block.getStateDefinition().getProperty("disabled");
        IntegerProperty STAGE_PROP = (IntegerProperty)block.getStateDefinition().getProperty("stage");
        if (ACTIVE == null || DISABLED == null || STAGE_PROP == null) {
            return;
        }
        int stage = (Integer)state.getValue((Property)STAGE_PROP);
        boolean isWaterlogged = state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        BlockPos[] sides = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        boolean isUnderwater = false;
        for (BlockPos side : sides) {
            if (!level.getFluidState(side).is(FluidTags.WATER)) continue;
            isUnderwater = true;
            break;
        }
        if (isWaterlogged || isUnderwater) {
            if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 3);
            }
            return;
        }
        BlockPos abovePos = pos.above();
        AABB box = new AABB((double)pos.getX() - 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5, (double)abovePos.getX() + 1.5, (double)abovePos.getY() + 1.2, (double)abovePos.getZ() + 1.5);
        List bolts = level.getEntitiesOfClass(LightningBolt.class, box, e -> true);
        if (!bolts.isEmpty()) {
            RandomSource random = level.random;
            Block currentBlock = state.getBlock();
            for (int i = 0; i < 9; ++i) {
                CorruptedLefontiBlockEvents.handleRandomTick(currentBlock, state, level, pos, random);
            }
            return;
        }
        AABB area = new AABB(pos).inflate(8.0);
        boolean inEnd = level.dimension() == Level.END;
        TagKey enderTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.tryParse((String)"c:enders"));
        boolean threatNearby = !level.getEntitiesOfClass(Entity.class, area, e -> e.getType().is(enderTag)).isEmpty();
        boolean bl = shouldBeActive = !inEnd && !threatNearby;
        if ((Boolean)state.getValue((Property)ACTIVE) != shouldBeActive) {
            state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive));
            level.setBlock(pos, state, 3);
        }
        int radius = switch (stage) {
            case 1 -> 2;
            case 2 -> 5;
            case 3 -> 8;
            default -> 0;
        };
        AABB deathArea = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        List entities = level.getEntitiesOfClass(LivingEntity.class, deathArea);
        for (LivingEntity entity : entities) {
            if (entity.isAlive()) continue;
            BlockPos posBelow = entity.blockPosition().below();
            CorruptedLefontiBlockEvents.spreadSculk(level, posBelow, 2, level.random);
        }
    }

    public static void handleRandomTick(Block block, BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        double dzF;
        int dz;
        double dyF;
        int dy;
        double w;
        double r;
        double dxF;
        int dx;
        BooleanProperty ACTIVE = (BooleanProperty)block.getStateDefinition().getProperty("active");
        BooleanProperty DISABLED = (BooleanProperty)block.getStateDefinition().getProperty("disabled");
        IntegerProperty TICK_COUNT = (IntegerProperty)block.getStateDefinition().getProperty("tick_count");
        IntegerProperty STAGE_PROP = (IntegerProperty)block.getStateDefinition().getProperty("stage");
        boolean CRYSTAL_GREIFING = level.getGameRules().getBoolean(ModGameRules.CRYSTAL_GREIFING);
        if (ACTIVE == null || DISABLED == null || TICK_COUNT == null || STAGE_PROP == null) {
            return;
        }
        if (((Boolean)state.getValue((Property)DISABLED)).booleanValue() || !((Boolean)state.getValue((Property)ACTIVE)).booleanValue() || !CRYSTAL_GREIFING) {
            return;
        }
        int tickCount = (Integer)state.getValue((Property)TICK_COUNT) + 1;
        int stage = (Integer)state.getValue((Property)STAGE_PROP);
        if (tickCount >= 8) {
            tickCount = 0;
            stage = Math.min(stage + 1, 3);
        }
        state = (BlockState)((BlockState)state.setValue((Property)TICK_COUNT, (Comparable)Integer.valueOf(tickCount))).setValue((Property)STAGE_PROP, (Comparable)Integer.valueOf(stage));
        level.setBlock(pos, state, 3);
        int radius = switch (stage) {
            case 1 -> 2;
            case 2 -> 5;
            case 3 -> 8;
            default -> 0;
        };
        do {
            double u = random.nextDouble();
            double v = random.nextDouble();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            dxF = Math.sin(phi) * Math.cos(theta);
            dyF = Math.sin(phi) * Math.sin(theta);
            dzF = Math.cos(phi);
        } while ((dx = (int)Math.round(dxF * (r = (double)radius * Math.cbrt(w = random.nextDouble())))) * dx + (dy = (int)Math.round(dyF * r)) * dy + (dz = (int)Math.round(dzF * r)) * dz > radius * radius);
        BlockPos targetPos = pos.offset(dx, dy, dz);
        BlockState targetState = level.getBlockState(targetPos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            serverLevel.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, targetPos.getCenter(), Vec2.ZERO, serverLevel, 4, "", (Component)Component.literal((String)""), serverLevel.getServer(), null).withSuppressedOutput(), "fillbiome ~-1 ~-1 ~-1 ~1 ~1 ~1 dragonights:corrupted_lefonti_wasteland");
        }
        DamageSource magic = new DamageSource((Holder)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(MAGIC_DAMAGE), null, null, null);
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius)));
        for (LivingEntity entity : entities) {
            if (entity.getType().is(EntityTypeTags.UNDEAD) || entity.getType() == EntityType.IRON_GOLEM || entity.getType() == EntityType.SNOW_GOLEM || entity.getType() == EntityType.WARDEN) continue;
            entity.hurt(magic, 3.0f);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState belowState;
                    BlockPos checkPos = targetPos.offset(x, y, z);
                    BlockState checkState = level.getBlockState(checkPos);
                    if (!checkState.is(BlockTags.LEAVES)) continue;
                    level.setBlock(checkPos, Blocks.AIR.defaultBlockState(), 3);
                    BlockPos scanPos = checkPos.below();
                    while (scanPos.getY() > 0 && ((belowState = level.getBlockState(scanPos)).canBeReplaced() || belowState.isAir())) {
                        scanPos = scanPos.below();
                    }
                    BlockPos litterPos = scanPos.above();
                    BlockState litterState = level.getBlockState(litterPos);
                    Block block2 = litterState.getBlock();
                    if (block2 instanceof LeafLitterBlock) {
                        LeafLitterBlock leafLitter = (LeafLitterBlock)block2;
                        int currentLayers = (Integer)litterState.getValue((Property)leafLitter.getSegmentAmountProperty());
                        int newLayers = Math.min(currentLayers + 1, 4);
                        litterState = (BlockState)litterState.setValue((Property)leafLitter.getSegmentAmountProperty(), (Comparable)Integer.valueOf(newLayers));
                    } else {
                        if (!litterState.isAir()) continue;
                        litterState = Blocks.LEAF_LITTER.defaultBlockState();
                    }
                    level.setBlock(litterPos, litterState, 3);
                }
            }
        }
        CorruptedLefontiAbilities.decay.execute(level, targetPos, targetState, random, "block", null, null);
        Block newBlock = CorruptedLefontiBlockEvents.getReplacementForStage(targetState, stage);
        if (newBlock != null) {
            BlockState newState = newBlock.defaultBlockState();
            for (Property property : targetState.getProperties()) {
                if (!newState.hasProperty(property)) continue;
                newState = (BlockState)newState.setValue(property, targetState.getValue(property));
            }
            level.levelEvent(2001, targetPos, Block.getId((BlockState)targetState));
            SoundType placeSoundType = newBlock.getSoundType(newState, (LevelReader)level, targetPos, null);
            level.playSound(null, targetPos, placeSoundType.getPlaceSound(), SoundSource.BLOCKS, (placeSoundType.getVolume() + 1.0f) / 2.0f, placeSoundType.getPitch() * 0.8f);
            level.setBlock(targetPos, newState, 3);
        }
    }

    private static Block getReplacementForStage(BlockState state, int stage) {
        Block b;
        if (stage >= 1 && (b = CorruptedLefontiBlockEvents.getReplacementFromMaps(state, CORRUPTED_LEFONTI_STAGE_1_BLOCKS, CORRUPTED_LEFONTI_STAGE_1_TAGS)) != null) {
            return b;
        }
        if (stage >= 2 && (b = CorruptedLefontiBlockEvents.getReplacementFromMaps(state, CORRUPTED_LEFONTI_STAGE_2_BLOCKS, CORRUPTED_LEFONTI_STAGE_2_TAGS)) != null) {
            return b;
        }
        if (stage >= 3 && (b = CorruptedLefontiBlockEvents.getReplacementFromMaps(state, CORRUPTED_LEFONTI_STAGE_3_BLOCKS, CORRUPTED_LEFONTI_STAGE_3_TAGS)) != null) {
            return b;
        }
        return null;
    }

    private static Block getReplacementFromMaps(BlockState state, Map<Block, Block> blockMap, Map<TagKey<Block>, Block> tagMap) {
        Block b = blockMap.get(state.getBlock());
        if (b != null) {
            return b;
        }
        if (tagMap != null) {
            for (Map.Entry<TagKey<Block>, Block> entry : tagMap.entrySet()) {
                if (!state.is(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    static {
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BRAIN_CORAL, Blocks.DEAD_BRAIN_CORAL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BUBBLE_CORAL, Blocks.DEAD_BUBBLE_CORAL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.FIRE_CORAL, Blocks.DEAD_FIRE_CORAL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.HORN_CORAL, Blocks.DEAD_HORN_CORAL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.TUBE_CORAL, Blocks.DEAD_TUBE_CORAL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BRAIN_CORAL_BLOCK, Blocks.DEAD_BRAIN_CORAL_BLOCK);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BUBBLE_CORAL_BLOCK, Blocks.DEAD_BUBBLE_CORAL_BLOCK);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.FIRE_CORAL_BLOCK, Blocks.DEAD_FIRE_CORAL_BLOCK);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.HORN_CORAL_BLOCK, Blocks.DEAD_HORN_CORAL_BLOCK);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.TUBE_CORAL_BLOCK, Blocks.DEAD_TUBE_CORAL_BLOCK);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BRAIN_CORAL_FAN, Blocks.DEAD_BRAIN_CORAL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BUBBLE_CORAL_FAN, Blocks.DEAD_BUBBLE_CORAL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.FIRE_CORAL_FAN, Blocks.DEAD_FIRE_CORAL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.HORN_CORAL_FAN, Blocks.DEAD_HORN_CORAL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.TUBE_CORAL_FAN, Blocks.DEAD_TUBE_CORAL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BRAIN_CORAL_WALL_FAN, Blocks.DEAD_BRAIN_CORAL_WALL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.BUBBLE_CORAL_WALL_FAN, Blocks.DEAD_BUBBLE_CORAL_WALL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.FIRE_CORAL_WALL_FAN, Blocks.DEAD_FIRE_CORAL_WALL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.HORN_CORAL_WALL_FAN, Blocks.DEAD_HORN_CORAL_WALL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.TUBE_CORAL_WALL_FAN, Blocks.DEAD_TUBE_CORAL_WALL_FAN);
        CORRUPTED_LEFONTI_STAGE_1_TAGS.put(DIRT, Blocks.COARSE_DIRT);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.FARMLAND, Blocks.COARSE_DIRT);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_COBBLESTONE, Blocks.COBBLESTONE);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_COBBLESTONE_STAIRS, Blocks.COBBLESTONE_STAIRS);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_COBBLESTONE_SLAB, Blocks.COBBLESTONE_SLAB);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_COBBLESTONE_WALL, Blocks.COBBLESTONE_WALL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_STONE_BRICKS, Blocks.STONE_BRICKS);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.INFESTED_MOSSY_STONE_BRICKS, Blocks.INFESTED_STONE_BRICKS);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_STONE_BRICK_STAIRS, Blocks.STONE_BRICK_STAIRS);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.STONE_BRICK_SLAB);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(Blocks.MOSSY_STONE_BRICK_WALL, Blocks.STONE_BRICK_WALL);
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put((Block)ModBlocks.MOSSY_CHONDRITE_BRICK_STAIRS.get(), (Block)ModBlocks.CHONDRITE_BRICKS.get());
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put((Block)ModBlocks.MOSSY_CHONDRITE_BRICK_STAIRS.get(), (Block)ModBlocks.CHONDRITE_BRICK_STAIRS.get());
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put((Block)ModBlocks.MOSSY_CHONDRITE_BRICK_SLAB.get(), (Block)ModBlocks.CHONDRITE_BRICK_SLAB.get());
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put((Block)ModBlocks.MOSSY_CHONDRITE_BRICK_WALL.get(), (Block)ModBlocks.CHONDRITE_BRICK_WALL.get());
    }
}

