/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.items;

import com.j9studios.dragonights.abilities.LefontiAbilities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LefontiHoeItem
extends HoeItem {
    public LefontiHoeItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BonemealableBlock growable;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            return super.useOn(context);
        }
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = serverLevel.getBlockState(pos);
        ItemStack held = context.getItemInHand();
        if (LefontiAbilities.bonemeal == null) {
            return InteractionResult.PASS;
        }
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, pos, state)) {
            LefontiAbilities.bonemeal.execute(serverLevel, pos, state, serverLevel.getRandom(), "item", player, held);
            player.swing(context.getHand(), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

