/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.blocks;

import com.j9studios.dragonights.events.blocks.LefontiBlockEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;

public class LefontiWallBlock
extends WallBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty DISABLED = BooleanProperty.create((String)"disabled");
    public static final IntegerProperty TICK_COUNT = IntegerProperty.create((String)"tick_count", (int)0, (int)8);
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"radius", (int)1, (int)5);

    public LefontiWallBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.EAST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.SOUTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.WEST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)TICK_COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, BlockStateProperties.NORTH_WALL, BlockStateProperties.EAST_WALL, BlockStateProperties.SOUTH_WALL, BlockStateProperties.WEST_WALL, BlockStateProperties.WATERLOGGED, ACTIVE, DISABLED, TICK_COUNT, STAGE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        LefontiBlockEvents.handleTick((Block)this, state, level, pos);
        level.scheduleTick(pos, (Block)this, 1);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        LefontiBlockEvents.handleRandomTick((Block)this, state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

