/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.events.blocks;

import com.j9studios.dragonights.registry.ModGameRules;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;

public class LefontiBlockEvents {
    public static final TagKey<Block> DIRT = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"minecraft:dirt"));
    public static final TagKey<Block> SANDS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:sands"));
    public static final TagKey<Block> GRAVELS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:gravels"));
    public static final TagKey<Block> WOOD = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:wood"));
    public static final TagKey<Block> MUSHROOMS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:mushrooms"));
    public static final TagKey<Block> COBBLESTONES_MOSSY = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:cobblestones/mossy"));
    public static final TagKey<Block> STONES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:stones"));
    public static final TagKey<Block> ICE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"minecraft:ice"));
    public static final TagKey<Block> SNOW = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"minecraft:snow"));
    public static final TagKey<Block> SCULKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)"c:sculks"));
    public static final Map<Block, Block> LEFONTI_STAGE_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> LEFONTI_STAGE_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> LEFONTI_STAGE_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> LEFONTI_STAGE_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> LEFONTI_STAGE_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> LEFONTI_STAGE_3_TAGS = new HashMap<TagKey<Block>, Block>();

    public static void handleTick(Block block, BlockState state, ServerLevel level, BlockPos pos) {
        boolean shouldBeActive;
        boolean inEnd;
        BooleanProperty ACTIVE = (BooleanProperty)block.getStateDefinition().getProperty("active");
        BooleanProperty DISABLED = (BooleanProperty)block.getStateDefinition().getProperty("disabled");
        if (ACTIVE == null || DISABLED == null) {
            return;
        }
        boolean isWaterlogged = state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        BlockPos[] sides = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        boolean isUnderwater = false;
        for (BlockPos side : sides) {
            if (!level.getFluidState(side).is(FluidTags.WATER)) continue;
            isUnderwater = true;
            break;
        }
        AABB area = new AABB(pos).inflate(8.0);
        boolean bl = inEnd = level.dimension() == Level.END;
        if (isWaterlogged || isUnderwater) {
            if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 3);
            }
            return;
        }
        BlockPos abovePos = pos.above();
        AABB box = new AABB((double)pos.getX() - 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5, (double)abovePos.getX() + 1.5, (double)abovePos.getY() + 1.2, (double)abovePos.getZ() + 1.5);
        List bolts = level.getEntitiesOfClass(LightningBolt.class, box, e -> true);
        if (!bolts.isEmpty()) {
            RandomSource random = level.random;
            Block currentBlock = state.getBlock();
            for (int i = 0; i < 9; ++i) {
                LefontiBlockEvents.handleRandomTick(currentBlock, state, level, pos, random);
            }
            return;
        }
        TagKey enderTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.tryParse((String)"c:enders"));
        boolean threatNearby = !level.getEntitiesOfClass(Entity.class, area, entity -> entity.getType().is(enderTag)).isEmpty();
        boolean bl2 = shouldBeActive = !inEnd && !threatNearby;
        if ((Boolean)state.getValue((Property)ACTIVE) != shouldBeActive) {
            state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive));
            level.setBlock(pos, state, 3);
        }
    }

    public static void handleRandomTick(Block block, BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BonemealableBlock growable;
        Block theta2;
        double dzF;
        int dz;
        double dyF;
        int dy;
        double w;
        double r;
        double dxF;
        int dx;
        BooleanProperty ACTIVE = (BooleanProperty)block.getStateDefinition().getProperty("active");
        BooleanProperty DISABLED = (BooleanProperty)block.getStateDefinition().getProperty("disabled");
        IntegerProperty TICK_COUNT = (IntegerProperty)block.getStateDefinition().getProperty("tick_count");
        IntegerProperty STAGE_PROP = (IntegerProperty)block.getStateDefinition().getProperty("stage");
        boolean CRYSTAL_GREIFING = level.getGameRules().getBoolean(ModGameRules.CRYSTAL_GREIFING);
        if (ACTIVE == null || DISABLED == null || TICK_COUNT == null || STAGE_PROP == null) {
            return;
        }
        if (((Boolean)state.getValue((Property)DISABLED)).booleanValue() || !((Boolean)state.getValue((Property)ACTIVE)).booleanValue() || !CRYSTAL_GREIFING) {
            return;
        }
        int tickCount = (Integer)state.getValue((Property)TICK_COUNT) + 1;
        int stage = (Integer)state.getValue((Property)STAGE_PROP);
        if (tickCount >= 8) {
            tickCount = 0;
            stage = Math.min(stage + 1, 3);
        }
        state = (BlockState)((BlockState)state.setValue((Property)TICK_COUNT, (Comparable)Integer.valueOf(tickCount))).setValue((Property)STAGE_PROP, (Comparable)Integer.valueOf(stage));
        level.setBlock(pos, state, 3);
        int radius = switch (stage) {
            case 1 -> 2;
            case 2 -> 5;
            case 3 -> 8;
            default -> 0;
        };
        do {
            double u = random.nextDouble();
            double v = random.nextDouble();
            double theta2 = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            dxF = Math.sin(phi) * Math.cos(theta2);
            dyF = Math.sin(phi) * Math.sin(theta2);
            dzF = Math.cos(phi);
        } while ((dx = (int)Math.round(dxF * (r = (double)radius * Math.cbrt(w = random.nextDouble())))) * dx + (dy = (int)Math.round(dyF * r)) * dy + (dz = (int)Math.round(dzF * r)) * dz > radius * radius);
        BlockPos targetPos = pos.offset(dx, dy, dz);
        BlockState targetState = level.getBlockState(targetPos);
        BlockState below = level.getBlockState(targetPos.below());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            serverLevel.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, targetPos.getCenter(), Vec2.ZERO, serverLevel, 4, "", (Component)Component.literal((String)""), serverLevel.getServer(), null).withSuppressedOutput(), "fillbiome ~-1 ~-1 ~-1 ~1 ~1 ~1 dragonights:lefonti_jungle");
        }
        if ((theta2 = targetState.getBlock()) instanceof BonemealableBlock && (growable = (BonemealableBlock)theta2).isValidBonemealTarget((LevelReader)level, targetPos, targetState)) {
            growable.performBonemeal(level, random, targetPos, targetState);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = targetPos.offset(x, y, z);
                    BlockState checkState = level.getBlockState(checkPos);
                    if (checkState.is(ICE)) {
                        level.setBlock(checkPos, Blocks.WATER.defaultBlockState(), 3);
                        continue;
                    }
                    if (!checkState.is(SNOW)) continue;
                    level.setBlock(checkPos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
        Block newBlock = LefontiBlockEvents.getReplacementForStage(targetState, stage);
        if (newBlock != null) {
            BlockState newState = newBlock.defaultBlockState();
            for (Property property : targetState.getProperties()) {
                if (!newState.hasProperty(property)) continue;
                newState = (BlockState)newState.setValue(property, targetState.getValue(property));
            }
            level.levelEvent(2001, targetPos, Block.getId((BlockState)targetState));
            SoundType placeSoundType = newBlock.getSoundType(newState, (LevelReader)level, targetPos, null);
            level.playSound(null, targetPos, placeSoundType.getPlaceSound(), SoundSource.BLOCKS, (placeSoundType.getVolume() + 1.0f) / 2.0f, placeSoundType.getPitch() * 0.8f);
            level.setBlock(targetPos, newState, 3);
        }
        if (stage >= 2 && level.isEmptyBlock(targetPos) && below.is(WOOD) && below.isFaceSturdy((BlockGetter)level, targetPos.below(), Direction.UP)) {
            level.setBlock(targetPos, Blocks.MOSS_CARPET.defaultBlockState(), 3);
        }
        if (stage >= 2 && level.isEmptyBlock(targetPos)) {
            BlockPos[] neighbors;
            for (BlockPos neighbor : neighbors = new BlockPos[]{targetPos.north(), targetPos.south(), targetPos.east(), targetPos.west(), targetPos.above()}) {
                BlockState neighborState = level.getBlockState(neighbor);
                if (!neighborState.is(Blocks.COBBLESTONE) && !neighborState.is(BlockTags.LOGS)) continue;
                BlockState vineState = Blocks.VINE.defaultBlockState();
                if (neighbor.equals((Object)targetPos.north())) {
                    vineState = (BlockState)vineState.setValue((Property)VineBlock.NORTH, (Comparable)Boolean.valueOf(true));
                } else if (neighbor.equals((Object)targetPos.south())) {
                    vineState = (BlockState)vineState.setValue((Property)VineBlock.SOUTH, (Comparable)Boolean.valueOf(true));
                } else if (neighbor.equals((Object)targetPos.east())) {
                    vineState = (BlockState)vineState.setValue((Property)VineBlock.EAST, (Comparable)Boolean.valueOf(true));
                } else if (neighbor.equals((Object)targetPos.west())) {
                    vineState = (BlockState)vineState.setValue((Property)VineBlock.WEST, (Comparable)Boolean.valueOf(true));
                } else if (neighbor.equals((Object)targetPos.above())) {
                    vineState = (BlockState)vineState.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(true));
                }
                level.setBlock(targetPos, vineState, 3);
                break;
            }
        }
        if (stage >= 3 && level.isEmptyBlock(targetPos) && below.is(STONES) && below.isFaceSturdy((BlockGetter)level, targetPos.below(), Direction.UP)) {
            level.setBlock(targetPos, Blocks.MOSS_CARPET.defaultBlockState(), 3);
        }
    }

    private static Block getReplacementForStage(BlockState state, int stage) {
        Block b;
        if (stage >= 1 && (b = LefontiBlockEvents.getReplacementFromMaps(state, LEFONTI_STAGE_1_BLOCKS, LEFONTI_STAGE_1_TAGS)) != null) {
            return b;
        }
        if (stage >= 2 && (b = LefontiBlockEvents.getReplacementFromMaps(state, LEFONTI_STAGE_2_BLOCKS, LEFONTI_STAGE_2_TAGS)) != null) {
            return b;
        }
        if (stage >= 3 && (b = LefontiBlockEvents.getReplacementFromMaps(state, LEFONTI_STAGE_3_BLOCKS, LEFONTI_STAGE_3_TAGS)) != null) {
            return b;
        }
        return null;
    }

    private static Block getReplacementFromMaps(BlockState state, Map<Block, Block> blockMap, Map<TagKey<Block>, Block> tagMap) {
        Block b = blockMap.get(state.getBlock());
        if (b != null) {
            return b;
        }
        if (tagMap != null) {
            for (Map.Entry<TagKey<Block>, Block> entry : tagMap.entrySet()) {
                if (!state.is(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    static {
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BUSH, Blocks.BUSH);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.LEAF_LITTER, Blocks.SHORT_GRASS);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.SHORT_DRY_GRASS, Blocks.SHORT_GRASS);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.TALL_DRY_GRASS, Blocks.SHORT_GRASS);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BRAIN_CORAL, Blocks.BRAIN_CORAL);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BUBBLE_CORAL, Blocks.BUBBLE_CORAL);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_FIRE_CORAL, Blocks.FIRE_CORAL);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_HORN_CORAL, Blocks.HORN_CORAL);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_TUBE_CORAL, Blocks.TUBE_CORAL);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BRAIN_CORAL_BLOCK, Blocks.BRAIN_CORAL_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BUBBLE_CORAL_BLOCK, Blocks.BUBBLE_CORAL_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_FIRE_CORAL_BLOCK, Blocks.FIRE_CORAL_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_HORN_CORAL_BLOCK, Blocks.HORN_CORAL_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_TUBE_CORAL_BLOCK, Blocks.TUBE_CORAL_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BRAIN_CORAL_FAN, Blocks.BRAIN_CORAL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BUBBLE_CORAL_FAN, Blocks.BUBBLE_CORAL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_FIRE_CORAL_FAN, Blocks.FIRE_CORAL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_HORN_CORAL_FAN, Blocks.HORN_CORAL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_TUBE_CORAL_FAN, Blocks.TUBE_CORAL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BRAIN_CORAL_WALL_FAN, Blocks.BRAIN_CORAL_WALL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_BUBBLE_CORAL_WALL_FAN, Blocks.BUBBLE_CORAL_WALL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_FIRE_CORAL_WALL_FAN, Blocks.FIRE_CORAL_WALL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_HORN_CORAL_WALL_FAN, Blocks.HORN_CORAL_WALL_FAN);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DEAD_TUBE_CORAL_WALL_FAN, Blocks.TUBE_CORAL_WALL_FAN);
        LEFONTI_STAGE_1_TAGS.put(DIRT, Blocks.GRASS_BLOCK);
        LEFONTI_STAGE_1_BLOCKS.put(Blocks.DIRT_PATH, Blocks.DIRT);
        LEFONTI_STAGE_2_TAGS.put(SANDS, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_TAGS.put(GRAVELS, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_BLOCKS.put(Blocks.CLAY, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_BLOCKS.put(Blocks.NETHERRACK, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_TAGS.put(WOOD, Blocks.MOSS_BLOCK);
        LEFONTI_STAGE_2_TAGS.put(MUSHROOMS, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_TAGS.put(SCULKS, Blocks.COARSE_DIRT);
        LEFONTI_STAGE_2_BLOCKS.put(Blocks.SCULK_VEIN, Blocks.AIR);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.COBBLESTONE, Blocks.MOSSY_COBBLESTONE);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.INFESTED_COBBLESTONE, Blocks.MOSSY_COBBLESTONE);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.COBBLESTONE_STAIRS, Blocks.MOSSY_COBBLESTONE_STAIRS);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.COBBLESTONE_SLAB, Blocks.MOSSY_COBBLESTONE_SLAB);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.COBBLESTONE_WALL, Blocks.MOSSY_COBBLESTONE_WALL);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.STONE_BRICKS, Blocks.MOSSY_STONE_BRICKS);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.INFESTED_STONE_BRICKS, Blocks.INFESTED_MOSSY_STONE_BRICKS);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.STONE_BRICK_STAIRS, Blocks.MOSSY_STONE_BRICK_STAIRS);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.STONE_BRICK_SLAB, Blocks.MOSSY_STONE_BRICK_SLAB);
        LEFONTI_STAGE_3_BLOCKS.put(Blocks.STONE_BRICK_WALL, Blocks.MOSSY_STONE_BRICK_WALL);
    }
}

