/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CorruptedLefontiHoeItem
extends HoeItem {
    public CorruptedLefontiHoeItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        boolean threatNearby;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockState state = level.getBlockState(pos);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            return super.useOn(context);
        }
        boolean inEnd = level.dimension() == Level.END;
        boolean fullyUnderwater = player.isEyeInFluid(FluidTags.WATER);
        TagKey enderTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.tryParse((String)"c:enders"));
        AABB area = player.getBoundingBox().inflate(8.0);
        boolean bl = threatNearby = !level.getEntitiesOfClass(Entity.class, area, entity -> entity.getType().is(enderTag)).isEmpty();
        if ((inEnd || threatNearby) && !fullyUnderwater) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }
}

