/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights;

import com.j9studios.dragonights.abilities.CorruptedLefontiAbilities;
import com.j9studios.dragonights.abilities.FusiteAbilities;
import com.j9studios.dragonights.abilities.LefontiAbilities;
import com.j9studios.dragonights.abilities.corrupted_lefonti.CorruptedLefontiDecayAbility;
import com.j9studios.dragonights.abilities.fusite.FusiteErodeAbility;
import com.j9studios.dragonights.abilities.lefonti.LefontiGrowthAbility;
import com.j9studios.dragonights.events.common.FirstJoinMessages;
import com.j9studios.dragonights.events.items.AxeOozeHandler;
import com.j9studios.dragonights.network.ClientDragonightSync;
import com.j9studios.dragonights.network.SyncDragonightChargePacket;
import com.j9studios.dragonights.registry.ModBlocks;
import com.j9studios.dragonights.registry.ModBrewingRecipes;
import com.j9studios.dragonights.registry.ModCreativeTabs;
import com.j9studios.dragonights.registry.ModDataMaps;
import com.j9studios.dragonights.registry.ModEffects;
import com.j9studios.dragonights.registry.ModEntityBlocks;
import com.j9studios.dragonights.registry.ModGameRules;
import com.j9studios.dragonights.registry.ModItems;
import com.j9studios.dragonights.registry.ModParticleTypes;
import com.j9studios.dragonights.registry.ModPotions;
import com.j9studios.dragonights.variables.DragonightsPlayerData;
import com.j9studios.dragonights.variables.DragonightsPlayerDataProvider;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="dragonights")
public class DragonightsMod {
    public static final String MODID = "dragonights";
    public static final Logger LOGGER = LogUtils.getLogger();

    public DragonightsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(LefontiAbilities::registerNetworking);
        modEventBus.addListener(CorruptedLefontiAbilities::registerNetworking);
        modEventBus.addListener(FusiteAbilities::registerNetworking);
        modEventBus.addListener(DragonightsMod::onRegisterPayloads);
        modEventBus.addListener(DragonightsMod::onClientRegisterPayloads);
        ModBlocks.register(modEventBus);
        ModEntityBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModEffects.register(modEventBus);
        ModPotions.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModParticleTypes.register(modEventBus);
        ModGameRules.register();
        modEventBus.register(ModDataMaps.class);
        NeoForge.EVENT_BUS.addListener(AxeOozeHandler::onRightClickBlock);
        NeoForge.EVENT_BUS.addListener(ModBrewingRecipes::registerBrewingRecipes);
        LefontiAbilities.register();
        CorruptedLefontiAbilities.register();
        FusiteAbilities.register();
        NeoForge.EVENT_BUS.addListener(event -> {
            LefontiGrowthAbility.initReplacementMaps(event.getServer());
            CorruptedLefontiDecayAbility.initReplacementMaps(event.getServer());
            FusiteErodeAbility.initReplacementMaps(event.getServer());
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, LefontiAbilities::handleClientTick);
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, CorruptedLefontiAbilities::handleClientTick);
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, FusiteAbilities::handleClientTick);
        NeoForge.EVENT_BUS.addListener(RenderGuiEvent.Post.class, LefontiAbilities::handleRenderGui);
        NeoForge.EVENT_BUS.addListener(RenderGuiEvent.Post.class, CorruptedLefontiAbilities::handleRenderGui);
        NeoForge.EVENT_BUS.addListener(RenderGuiEvent.Post.class, FusiteAbilities::handleRenderGui);
        NeoForge.EVENT_BUS.register(FirstJoinMessages.class);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FUSITE_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_FUSITE_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
    }

    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(SyncDragonightChargePacket.TYPE, SyncDragonightChargePacket.STREAM_CODEC);
    }

    @SubscribeEvent
    public static void onClientRegisterPayloads(RegisterClientPayloadHandlersEvent event) {
        event.register(SyncDragonightChargePacket.TYPE, ClientDragonightSync::handle);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DragonightsPlayerData data = DragonightsPlayerDataProvider.get((Player)player2);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncDragonightChargePacket(data.getType()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

