/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities.corrupted_lefonti;

import com.j9studios.dragonights.GlobalReferences;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CorruptedLefontiDamageAbility {
    public void perform(Level level, BlockPos center, LivingEntity caster, int stage, String type) {
        if (level.isClientSide) {
            return;
        }
        double radius = CorruptedLefontiDamageAbility.getRadius(stage, type);
        float damage = CorruptedLefontiDamageAbility.getDamage(stage);
        if ("entity".equals(type) && stage == 1 && caster != null) {
            LivingEntity living;
            Entity target = CorruptedLefontiDamageAbility.getLookedAtEntity(caster, radius);
            if (target instanceof LivingEntity && !CorruptedLefontiDamageAbility.isImmune((Entity)(living = (LivingEntity)target))) {
                living.hurt(level.damageSources().magic(), damage);
            }
            return;
        }
        AABB area = new AABB((double)center.getX() - radius, (double)center.getY() - radius, (double)center.getZ() - radius, (double)center.getX() + radius, (double)center.getY() + radius, (double)center.getZ() + radius);
        List entities = level.getEntitiesOfClass(LivingEntity.class, area, e -> e.isAlive() && e != caster && !CorruptedLefontiDamageAbility.isImmune((Entity)e));
        for (LivingEntity entity : entities) {
            if (!(entity.distanceToSqr((double)center.getX(), (double)center.getY(), (double)center.getZ()) <= radius * radius)) continue;
            entity.hurt(level.damageSources().magic(), damage);
        }
    }

    private static double getRadius(int stage, String type) {
        if ("entity".equals(type) && stage == 1) {
            return 16.0;
        }
        return Math.min(3 * stage, 8);
    }

    private static float getDamage(int stage) {
        return 9.0f * (float)stage;
    }

    private static Entity getLookedAtEntity(LivingEntity caster, double distance) {
        Vec3 eyePos = caster.getEyePosition(1.0f);
        Vec3 lookVec = caster.getLookAngle();
        Vec3 reachVec = eyePos.add(lookVec.scale(distance));
        Entity closest = null;
        double closestDistSq = distance * distance;
        AABB searchBox = caster.getBoundingBox().expandTowards(lookVec.scale(distance)).inflate(1.0);
        List candidates = caster.level().getEntities((Entity)caster, searchBox, e -> e.isAlive() && e != caster && !CorruptedLefontiDamageAbility.isImmune(e));
        for (Entity e2 : candidates) {
            double distSq;
            AABB box = e2.getBoundingBox().inflate((double)e2.getPickRadius());
            Optional optionalHit = box.clip(eyePos, reachVec);
            if (!optionalHit.isPresent() || !((distSq = eyePos.distanceToSqr((Vec3)optionalHit.get())) < closestDistSq)) continue;
            closestDistSq = distSq;
            closest = e2;
        }
        return closest;
    }

    private static boolean isImmune(Entity entity) {
        return entity.getType().is(GlobalReferences.DragonightsIndex.EntityTags.IMMUNE_TO_CORRUPTED_LEFONTI);
    }
}

