/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities.fusite;

import com.j9studios.dragonights.DragonightsMod;
import com.j9studios.dragonights.GlobalReferences;
import com.j9studios.dragonights.abilities.DragoniteAbility;
import com.j9studios.dragonights.registry.ModDataMaps;
import com.j9studios.dragonights.utility.DataMapsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class FusiteErodeAbility
implements DragoniteAbility {
    private static final double RADIUS_MULTIPLIER = 1.0;
    public static final List<ReplacementRow> REPLACEMENT_MAP = new ArrayList<ReplacementRow>();
    public static final Map<Block, Block> FUSITE_STAGE_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_STAGE_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_STAGE_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_STAGE_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_STAGE_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_STAGE_3_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_4_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_5_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_6_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_7_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_8_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> FUSITE_RADIUS_9_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_3_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_4_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_5_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_6_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_7_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_8_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> FUSITE_RADIUS_9_TAGS = new HashMap<TagKey<Block>, Block>();

    public static boolean isValidTarget(ServerLevel level, BlockPos pos, BlockState state) {
        return state.is(GlobalReferences.DragonightsIndex.BlockTags.FUSITE_REPLACEABLE);
    }

    public static void initReplacementMaps(MinecraftServer server) {
        REPLACEMENT_MAP.clear();
        Map<String, ModDataMaps.FusiteData> allData = DataMapsHelper.parse(server, "dragonights", "block/fusite_replaceables", obj -> new ModDataMaps.FusiteData(obj.get("replaced").getAsString(), obj.get("stage").getAsInt(), obj.get("radius").getAsInt()));
        for (Map.Entry<String, ModDataMaps.FusiteData> entry : allData.entrySet()) {
            String key = entry.getKey();
            ModDataMaps.FusiteData data = entry.getValue();
            String[] parts = data.replaced().split(":", 2);
            if (parts.length != 2) {
                DragonightsMod.LOGGER.warn("Invalid block ID: {}", (Object)data.replaced());
                continue;
            }
            ResourceLocation replacementLoc = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            Block replacement = BuiltInRegistries.BLOCK.getOptional(replacementLoc).orElse(Blocks.AIR);
            boolean isTag = key.startsWith("#");
            REPLACEMENT_MAP.add(new ReplacementRow(key, replacement, data.stage(), data.radius(), isTag));
        }
    }

    private Block fetchReplacementBlock(BlockState state, int stage) {
        for (ReplacementRow row : REPLACEMENT_MAP) {
            Block block;
            ResourceLocation blockLoc;
            TagKey tag;
            ResourceLocation tagLoc;
            if (stage < row.stage() || !(row.isTag ? (tagLoc = ResourceLocation.tryParse((String)row.key().substring(1))) != null && state.is(tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagLoc)) : (blockLoc = ResourceLocation.tryParse((String)row.key())) != null && state.is(block = BuiltInRegistries.BLOCK.getOptional(blockLoc).orElse(Blocks.AIR)))) continue;
            return row.replacement();
        }
        return null;
    }

    private void replaceSingleBlock(ServerLevel level, BlockPos pos, Block newBlock, int stage, BlockState oldState) {
        BlockState newState = newBlock.defaultBlockState();
        for (Property property : oldState.getProperties()) {
            if (!newState.hasProperty(property)) continue;
            newState = (BlockState)newState.setValue(property, oldState.getValue(property));
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)oldState));
        SoundType soundType = newBlock.getSoundType(newState, (LevelReader)level, pos, null);
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.setBlock(pos, newState, 3);
        float particleHeight = newState.isSolidRender() ? 1.1f : 0.1f;
        level.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)pos.getX() + 0.5, (double)((float)pos.getY() + particleHeight), (double)pos.getZ() + 0.5, 15, 0.25, 0.1, 0.25, 0.05);
    }

    private int fetchBlockStage(BlockState state) {
        for (ReplacementRow row : REPLACEMENT_MAP) {
            Block block;
            ResourceLocation blockLoc;
            TagKey tag;
            ResourceLocation tagLoc;
            if (!(row.isTag ? (tagLoc = ResourceLocation.tryParse((String)row.key().substring(1))) != null && state.is(tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagLoc)) : (blockLoc = ResourceLocation.tryParse((String)row.key())) != null && state.is(block = BuiltInRegistries.BLOCK.getOptional(blockLoc).orElse(Blocks.AIR)))) continue;
            return row.stage();
        }
        return 1;
    }

    private int fetchBlockRadius(BlockState state) {
        for (ReplacementRow row : REPLACEMENT_MAP) {
            Block block;
            ResourceLocation blockLoc;
            TagKey tag;
            ResourceLocation tagLoc;
            if (!(row.isTag ? (tagLoc = ResourceLocation.tryParse((String)row.key().substring(1))) != null && state.is(tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagLoc)) : (blockLoc = ResourceLocation.tryParse((String)row.key())) != null && state.is(block = BuiltInRegistries.BLOCK.getOptional(blockLoc).orElse(Blocks.AIR)))) continue;
            return row.radius();
        }
        return 1;
    }

    private int calculateEffectiveRadius(BlockState state, int passStage) {
        int blockStage = this.fetchBlockStage(state);
        int blockRadius = this.fetchBlockRadius(state);
        if (passStage < blockStage) {
            return 0;
        }
        int stageMultiplier = passStage - blockStage + 1;
        return (int)((double)(blockRadius * stageMultiplier) * 1.0);
    }

    private boolean replaceBlock(ServerLevel level, BlockPos centerPos, int stage) {
        boolean replaced = false;
        int maxRadius = 9;
        for (int dx = -maxRadius; dx <= maxRadius; ++dx) {
            for (int dy = -maxRadius; dy <= maxRadius; ++dy) {
                for (int dz = -maxRadius; dz <= maxRadius; ++dz) {
                    BlockPos pos = centerPos.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(pos);
                    Block replacement = this.fetchReplacementBlock(state, stage);
                    if (replacement == null || state.is(replacement)) continue;
                    int effectiveRadius = this.calculateEffectiveRadius(state, stage);
                    boolean inside = false;
                    switch (effectiveRadius) {
                        case 1: {
                            inside = dx == 0 && dy == 0 && dz == 0;
                            break;
                        }
                        case 2: {
                            inside = Math.abs(dx) + Math.abs(dy) + Math.abs(dz) <= 1;
                            break;
                        }
                        case 3: {
                            inside = Math.abs(dx) <= 1 && Math.abs(dy) <= 1 && Math.abs(dz) <= 1;
                            break;
                        }
                        case 4: {
                            inside = Math.abs(dx) + Math.abs(dy) + Math.abs(dz) <= 2 || centerPos.distSqr((Vec3i)pos) <= 9.0;
                            break;
                        }
                        default: {
                            boolean bl = inside = centerPos.distSqr((Vec3i)pos) <= (double)(effectiveRadius * effectiveRadius);
                        }
                    }
                    if (!inside || !state.is(GlobalReferences.DragonightsIndex.BlockTags.FUSITE_REPLACEABLE)) continue;
                    this.replaceSingleBlock(level, pos, replacement, stage, state);
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    public void perform(ServerLevel level, BlockPos centerPos, BlockState state, RandomSource random, String sourceType, Player player, ItemStack handStack, Direction clickedFace, int stage) {
        if (!DragoniteAbility.canActivate(level, centerPos, state, sourceType, player)) {
            return;
        }
        if (state == null || stage < 1) {
            stage = 1;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            if (stage >= 3 && Objects.equals(sourceType, "block")) {
                serverLevel.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, centerPos.getCenter(), Vec2.ZERO, serverLevel, 4, "", (Component)Component.literal((String)""), serverLevel.getServer(), null).withSuppressedOutput(), "fillbiome ~-" + stage + " ~-" + stage + " ~-" + stage + " ~" + stage + " ~" + stage + " ~" + stage + " dragonights:fusite_desert");
            }
        }
        if (this.replaceBlock(level, centerPos, stage)) {
            return;
        }
        if ("item".equals(sourceType) && player != null && handStack != null) {
            if (handStack.isDamageableItem()) {
                handStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            } else {
                handStack.shrink(1);
            }
        }
    }

    public record ReplacementRow(String key, Block replacement, int stage, int radius, boolean isTag) {
    }
}

