/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.blocks;

import com.j9studios.dragonights.abilities.DragoniteAbility;
import com.j9studios.dragonights.events.blocks.FusiteBlockEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class FusiteClusterBlock
extends AmethystClusterBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty DISABLED = BooleanProperty.create((String)"disabled");
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)1, (int)3);

    public FusiteClusterBlock(float tipLength, float baseLength, BlockBehaviour.Properties properties) {
        super(tipLength, baseLength, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED, ACTIVE, DISABLED, STAGE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        int r = 255;
        int g = 104;
        int b = 196;
        return r << 16 | g << 8 | b;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean lightningAbove;
        if (!DragoniteAbility.canActivate(level, pos, state, "block", null)) {
            state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 3);
        } else {
            state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 3);
        }
        boolean bl = lightningAbove = !level.getEntitiesOfClass(LightningBolt.class, new AABB(pos.below()).expandTowards(0.0, 1.0, 0.0)).isEmpty() || !level.getEntitiesOfClass(LightningBolt.class, new AABB(pos.below()).expandTowards(0.0, 2.0, 0.0)).isEmpty();
        if (lightningAbove) {
            for (int i = 0; i < 9; ++i) {
                this.randomTick(state, level, pos, random);
            }
        }
        level.scheduleTick(pos, (Block)this, 1);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        FusiteBlockEvents.handleRandomTick((Block)this, state, level, pos, random);
        boolean insideBeacon = false;
        for (int y = pos.getY() + 1; y < level.getMaxY(); ++y) {
            BlockState aboveState = level.getBlockState(new BlockPos(pos.getX(), y, pos.getZ()));
            if (!(aboveState.getBlock() instanceof BeaconBlock)) continue;
            insideBeacon = true;
            break;
        }
        if (insideBeacon) {
            for (int i = 0; i < 2; ++i) {
                FusiteBlockEvents.handleRandomTick((Block)this, state, level, pos, random);
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

