/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.effects;

import com.j9studios.dragonights.abilities.DragoniteAbility;
import com.j9studios.dragonights.network.SyncDragonightChargePacket;
import com.j9studios.dragonights.registry.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class LefontiCrystallizationEffect
extends MobEffect {
    private static final String TAG_CRYSTALLIZATION = "LefontiCrystallization";
    private static final String TAG_DRAGONIGHT_TYPE = "DragonightType";
    private static final String SUBTAG = "DragonightsData";

    public LefontiCrystallizationEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(ServerLevel level, LivingEntity entity, int amplifier) {
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos pos = player.blockPosition();
        if (DragoniteAbility.canActivate(level, pos, null, "effect", (Player)player)) {
            CompoundTag data = player.getPersistentData().getCompound(SUBTAG).orElse(new CompoundTag());
            int type = data.getInt(TAG_DRAGONIGHT_TYPE).orElse(0);
            int crystallization = data.getInt(TAG_CRYSTALLIZATION).orElse(0);
            if (player.getRandom().nextFloat() < 0.01f) {
                data.putInt(TAG_CRYSTALLIZATION, ++crystallization);
                player.getPersistentData().put(SUBTAG, (Tag)data);
            }
            if (crystallization >= 100 && type == 0) {
                data.putInt(TAG_DRAGONIGHT_TYPE, 1);
                player.getPersistentData().put(SUBTAG, (Tag)data);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDragonightChargePacket(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!level.isClientSide() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    ResourceLocation advId = ResourceLocation.tryParse((String)"dragonights:dragonights/dragonight");
                    if (advId != null) {
                        serverPlayer.getServer().getAdvancements().getAllAdvancements().stream().filter(adv -> adv.id().equals((Object)advId)).forEach(adv -> serverPlayer.getAdvancements().getOrStartProgress(adv).getRemainingCriteria().forEach(criterion -> serverPlayer.getAdvancements().award(adv, criterion)));
                    }
                }
            }
            if (crystallization != 100 && type == 0) {
                if (player.getRandom().nextFloat() < 0.005f) {
                    player.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 100, amplifier));
                }
                return true;
            }
            player.removeEffect(ModEffects.LEFONTI_CRYSTALLIZATION_EFFECT);
            return false;
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int tickCount, int amplifier) {
        return true;
    }
}

