/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.items;

import com.j9studios.dragonights.abilities.FusiteAbilities;
import com.j9studios.dragonights.abilities.fusite.FusiteErodeAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;

public class FusiteAxeItem
extends AxeItem {
    public FusiteAxeItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            return super.useOn(context);
        }
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = serverLevel.getBlockState(pos);
        ItemStack held = context.getItemInHand();
        Direction clickedFace = context.getClickedFace();
        if (FusiteAbilities.erode == null) {
            return InteractionResult.PASS;
        }
        if (FusiteErodeAbility.isValidTarget(serverLevel, pos, state)) {
            FusiteAbilities.erode.perform(serverLevel, pos, state, serverLevel.getRandom(), "item", player, held, null, 1);
            player.swing(context.getHand(), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

