/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.items;

import com.j9studios.dragonights.registry.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PearlOozeItem
extends Item {
    private static final Map<Block, Block> OOZEABLES = new HashMap<Block, Block>();

    public PearlOozeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block waxedBlock = OOZEABLES.get(state.getBlock());
        if (waxedBlock != null) {
            BlockState newState = waxedBlock.withPropertiesOf(state);
            Player player = context.getPlayer();
            ItemStack stack = context.getItemInHand();
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ResourceLocation advId = ResourceLocation.tryParse((String)"dragonights:dragonights/ooze_on");
                if (advId != null) {
                    serverPlayer.getServer().getAdvancements().getAllAdvancements().stream().filter(adv -> adv.id().equals((Object)advId)).forEach(adv -> serverPlayer.getAdvancements().getOrStartProgress(adv).getRemainingCriteria().forEach(criterion -> serverPlayer.getAdvancements().award(adv, criterion)));
                }
                stack.shrink(1);
                level.setBlock(pos, newState, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.4, 0.4, 0.4, 0.05);
                }
            } else {
                level.playSound((Entity)player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        OOZEABLES.put((Block)ModBlocks.LEFONTI_CLUSTER.get(), (Block)ModBlocks.OOZED_LEFONTI_CLUSTER.get());
        OOZEABLES.put((Block)ModBlocks.LEFONTI_BLOCK.get(), (Block)ModBlocks.OOZED_LEFONTI_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_LEFONTI_BLOCK.get(), (Block)ModBlocks.OOZED_POLISHED_LEFONTI_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_LEFONTI_STAIRS.get(), (Block)ModBlocks.OOZED_POLISHED_LEFONTI_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_LEFONTI_SLAB.get(), (Block)ModBlocks.OOZED_POLISHED_LEFONTI_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.LEFONTI_BRICKS.get(), (Block)ModBlocks.OOZED_LEFONTI_BRICKS.get());
        OOZEABLES.put((Block)ModBlocks.LEFONTI_BRICK_STAIRS.get(), (Block)ModBlocks.OOZED_LEFONTI_BRICK_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.LEFONTI_BRICK_SLAB.get(), (Block)ModBlocks.OOZED_LEFONTI_BRICK_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.LEFONTI_BRICK_WALL.get(), (Block)ModBlocks.OOZED_LEFONTI_BRICK_WALL.get());
        OOZEABLES.put((Block)ModBlocks.CHISELED_LEFONTI_BRICKS.get(), (Block)ModBlocks.OOZED_CHISELED_LEFONTI_BRICKS.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_CLUSTER.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_CLUSTER.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_BLOCK.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_BLOCK.get(), (Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_STAIRS.get(), (Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_SLAB.get(), (Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_BRICKS.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICKS.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_STAIRS.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_SLAB.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_WALL.get(), (Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_WALL.get());
        OOZEABLES.put((Block)ModBlocks.CHISELED_CORRUPTED_LEFONTI_BRICKS.get(), (Block)ModBlocks.OOZED_CHISELED_CORRUPTED_LEFONTI_BRICKS.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_CLUSTER.get(), (Block)ModBlocks.OOZED_FUSITE_CLUSTER.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_BLOCK.get(), (Block)ModBlocks.OOZED_FUSITE_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_FUSITE_BLOCK.get(), (Block)ModBlocks.OOZED_POLISHED_FUSITE_BLOCK.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_FUSITE_STAIRS.get(), (Block)ModBlocks.OOZED_POLISHED_FUSITE_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.POLISHED_FUSITE_SLAB.get(), (Block)ModBlocks.OOZED_POLISHED_FUSITE_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_BRICKS.get(), (Block)ModBlocks.OOZED_FUSITE_BRICKS.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_BRICK_STAIRS.get(), (Block)ModBlocks.OOZED_FUSITE_BRICK_STAIRS.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_BRICK_SLAB.get(), (Block)ModBlocks.OOZED_FUSITE_BRICK_SLAB.get());
        OOZEABLES.put((Block)ModBlocks.FUSITE_BRICK_WALL.get(), (Block)ModBlocks.OOZED_FUSITE_BRICK_WALL.get());
        OOZEABLES.put((Block)ModBlocks.CHISELED_FUSITE_BRICKS.get(), (Block)ModBlocks.OOZED_CHISELED_FUSITE_BRICKS.get());
    }
}

