/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class DataMapsHelper {
    public static <T> Map<String, T> parse(MinecraftServer server, String namespace, String path, Function<JsonObject, T> mapper) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        try {
            ResourceLocation fileLoc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("data_maps/" + path + ".json"));
            ResourceManager resourceManager = server.getResourceManager();
            Optional res = resourceManager.getResource(fileLoc);
            if (res.isEmpty()) {
                System.out.println("Could not find data map JSON: " + String.valueOf(fileLoc));
                return result;
            }
            try (InputStreamReader reader = new InputStreamReader(((Resource)res.get()).open(), StandardCharsets.UTF_8);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject values = root.getAsJsonObject("values");
                for (Map.Entry entry : values.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    result.put(key, mapper.apply(obj));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

