/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.variables;

import com.j9studios.dragonights.network.SyncDragonightChargePacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class DragonightsPlayerDataStorage {
    private static final String TAG_DRAGONIGHT_TYPE = "DragonightType";
    private static final String TAG_LEFONTI_CRYSTALLIZATION = "LefontiCrystallization";
    private static final String SUBTAG = "DragonightsData";

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompoundTag data = player2.getPersistentData().getCompound(SUBTAG).orElse(new CompoundTag());
        int type = data.getInt(TAG_DRAGONIGHT_TYPE).orElse(0);
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncDragonightChargePacket(type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        CompoundTag originalData = event.getOriginal().getPersistentData().getCompound(SUBTAG).orElse(new CompoundTag());
        CompoundTag newData = event.getEntity().getPersistentData().getCompound(SUBTAG).orElse(new CompoundTag());
        newData.putInt(TAG_DRAGONIGHT_TYPE, originalData.getInt(TAG_DRAGONIGHT_TYPE).orElse(0).intValue());
        newData.putInt(TAG_LEFONTI_CRYSTALLIZATION, originalData.getInt(TAG_LEFONTI_CRYSTALLIZATION).orElse(0).intValue());
        event.getEntity().getPersistentData().put(SUBTAG, (Tag)newData);
    }
}

