/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights;

import com.j9studios.dragonights.abilities.CorruptedLefontiAbilities;
import com.j9studios.dragonights.abilities.LefontiAbilities;
import com.j9studios.dragonights.abilities.corrupted_lefonti.CorruptedLefontiDecayAbility;
import com.j9studios.dragonights.abilities.lefonti.LefontiGrowthAbility;
import com.j9studios.dragonights.events.common.FirstJoinMessages;
import com.j9studios.dragonights.events.items.AxeOozeHandler;
import com.j9studios.dragonights.network.ClientDragonightSync;
import com.j9studios.dragonights.network.SyncDragonightChargePacket;
import com.j9studios.dragonights.registry.ModBlocks;
import com.j9studios.dragonights.registry.ModCreativeTabs;
import com.j9studios.dragonights.registry.ModDataMaps;
import com.j9studios.dragonights.registry.ModEntityBlocks;
import com.j9studios.dragonights.registry.ModGameRules;
import com.j9studios.dragonights.registry.ModItems;
import com.j9studios.dragonights.registry.ModParticleTypes;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="dragonights")
public class DragonightsMod {
    public static final String MODID = "dragonights";
    public static final Logger LOGGER = LogUtils.getLogger();

    public DragonightsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(LefontiAbilities::registerNetworking);
        modEventBus.addListener(CorruptedLefontiAbilities::registerNetworking);
        ModBlocks.register(modEventBus);
        ModEntityBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModParticleTypes.register(modEventBus);
        ModGameRules.register();
        modEventBus.register(ModDataMaps.class);
        NeoForge.EVENT_BUS.addListener(AxeOozeHandler::onRightClickBlock);
        LefontiAbilities.register();
        CorruptedLefontiAbilities.register();
        NeoForge.EVENT_BUS.addListener(event -> {
            LefontiGrowthAbility.initReplacementMaps(event.getServer());
            CorruptedLefontiDecayAbility.initReplacementMaps(event.getServer());
        });
        modEventBus.addListener(DragonightsMod::onRegisterPayloads);
        modEventBus.addListener(DragonightsMod::onClientRegisterPayloads);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(SyncDragonightChargePacket.TYPE, SyncDragonightChargePacket.STREAM_CODEC);
    }

    @SubscribeEvent
    public static void onClientRegisterPayloads(RegisterClientPayloadHandlersEvent event) {
        event.register(SyncDragonightChargePacket.TYPE, ClientDragonightSync::handle);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, LefontiAbilities::handleClientTick);
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, CorruptedLefontiAbilities::handleClientTick);
        NeoForge.EVENT_BUS.addListener(RenderGuiEvent.Post.class, LefontiAbilities::handleRenderGui);
        NeoForge.EVENT_BUS.addListener(RenderGuiEvent.Post.class, CorruptedLefontiAbilities::handleRenderGui);
        NeoForge.EVENT_BUS.register(FirstJoinMessages.class);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_CLUSTER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
    }
}

