/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities;

import com.j9studios.dragonights.GlobalReferences;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public interface DragoniteAbility {
    public static boolean canActivate(ServerLevel level, BlockPos pos, BlockState state, String sourceType, Player player) {
        boolean isWaterlogged = false;
        boolean isUnderwater = false;
        if ("block".equals(sourceType) && state != null) {
            isWaterlogged = state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
            for (BlockPos side : new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()}) {
                if (!level.getFluidState(side).is(FluidTags.WATER)) continue;
                isUnderwater = true;
                break;
            }
        } else if (("item".equals(sourceType) || "entity".equals(sourceType)) && player != null && (player.isInWater() || player.isInFluidType())) {
            isUnderwater = true;
        }
        if (isWaterlogged || isUnderwater) {
            return true;
        }
        boolean inEnd = level.dimension() == Level.END;
        boolean threatNearby = DragoniteAbility.hasNearbyThreat(level, pos, sourceType, player);
        if (inEnd || threatNearby) {
            if ("entity".equals(sourceType) || "item".equals(sourceType)) {
                level.playSound(null, pos, SoundEvents.ENDERMAN_SCREAM, SoundSource.PLAYERS, 1.0f, 1.0f + level.random.nextFloat());
                for (int i = 0; i < 8; ++i) {
                    double offsetX = level.random.nextDouble() - 0.5;
                    double offsetY = level.random.nextDouble();
                    double offsetZ = level.random.nextDouble() - 0.5;
                    level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 0.5 + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (player != null && !player.isCreative() && !player.isSpectator()) {
                double range = 8.0;
                List endermen = level.getEntitiesOfClass(EnderMan.class, player.getBoundingBox().inflate(range), LivingEntity::isAlive);
                for (EnderMan enderman : endermen) {
                    enderman.setTarget((LivingEntity)player);
                    enderman.lookAt((Entity)player, 30.0f, 30.0f);
                }
            }
            return false;
        }
        if ("block".equals(sourceType) && state != null) {
            BlockPos abovePos = pos.above();
            AABB lightningBox = new AABB((double)pos.getX() - 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5, (double)abovePos.getX() + 1.5, (double)abovePos.getY() + 1.2, (double)abovePos.getZ() + 1.5);
            List bolts = level.getEntitiesOfClass(LightningBolt.class, lightningBox, e -> true);
            if (!bolts.isEmpty()) {
                return true;
            }
        }
        return true;
    }

    private static boolean hasNearbyThreat(ServerLevel level, BlockPos pos, String sourceType, Player player) {
        if ("item".equals(sourceType) || "ability".equals(sourceType)) {
            if (player != null) {
                return !level.getEntitiesOfClass(Entity.class, player.getBoundingBox().inflate(8.0), e -> e.getType().is(GlobalReferences.DragonightsIndex.EntityTags.CAN_DEACTIVATE_DRAGONITE)).isEmpty();
            }
            return false;
        }
        return !level.getEntitiesOfClass(Entity.class, new AABB(pos).inflate(8.0), e -> e.getType().is(GlobalReferences.DragonightsIndex.EntityTags.CAN_DEACTIVATE_DRAGONITE)).isEmpty();
    }
}

