/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities;

import com.j9studios.dragonights.abilities.lefonti.LefontiGrowthAbility;
import com.j9studios.dragonights.abilities.lefonti.LefontiProjectileAbility;
import com.j9studios.dragonights.variables.DragonightsPlayerDataProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class LefontiAbilities {
    public static LefontiGrowthAbility growth;
    public static LefontiProjectileAbility projectile;
    public static final int MAX_CHARGE_TICKS = 20;
    private static int clientChargeTicks;
    private static boolean isCharging;
    private static final int CHARGE_THRESHOLD_TICKS = 4;
    private static int holdTicks;

    public static void register() {
        growth = new LefontiGrowthAbility();
        projectile = new LefontiProjectileAbility();
    }

    public static void handleClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int score = DragonightsPlayerDataProvider.get((Player)player).getCharge();
        if (score != 1) {
            return;
        }
        if (!player.getMainHandItem().isEmpty()) {
            holdTicks = 0;
            isCharging = false;
            clientChargeTicks = 0;
            return;
        }
        boolean holdingRightClick = Minecraft.getInstance().options.keyUse.isDown();
        if (holdingRightClick) {
            if (!isCharging && ++holdTicks >= 4) {
                isCharging = true;
                clientChargeTicks = 0;
            }
            if (isCharging) {
                clientChargeTicks = Math.min(clientChargeTicks + 1, 20);
            }
        } else {
            if (isCharging) {
                player.swing(InteractionHand.MAIN_HAND);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new ReleaseChargePacket(clientChargeTicks), (CustomPacketPayload[])new CustomPacketPayload[0]);
                clientChargeTicks = 0;
                isCharging = false;
            } else if (holdTicks > 0 && holdTicks < 4) {
                Minecraft mc = Minecraft.getInstance();
                HitResult result = mc.player.pick(5.0, 0.0f, false);
                if (result.getType() == HitResult.Type.BLOCK) {
                    BlockHitResult hit = (BlockHitResult)result;
                    BlockPos pos = hit.getBlockPos();
                    Direction face = hit.getDirection();
                    BlockState state = mc.level.getBlockState(pos);
                    player.swing(InteractionHand.MAIN_HAND);
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new ReleaseChargePacket(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            holdTicks = 0;
        }
    }

    public static void renderChargeBarAboveXP(RenderGuiEvent.Post event) {
        if (!isCharging) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        float progress = (float)clientChargeTicks / 20.0f;
        int width = 182;
        int height = 5;
        int x = (screenWidth - width) / 2;
        int y = screenHeight - 32;
        int color = clientChargeTicks >= 20 ? -13382401 : (clientChargeTicks >= 10 ? -13395457 : -13408513);
        event.getGuiGraphics().fill(x, y, x + width, y + height, 0x55000000);
        event.getGuiGraphics().fill(x, y, x + (int)(progress * (float)width), y + height, color);
    }

    public static void handleRenderGui(RenderGuiEvent.Post event) {
        LefontiAbilities.renderChargeBarAboveXP(event);
    }

    private static int getStageColor(int ticks) {
        if (ticks >= 20) {
            return -13382401;
        }
        if (ticks >= 10) {
            return -13395457;
        }
        return -13408513;
    }

    public static void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.NETWORK);
        registrar.playToServer(ReleaseChargePacket.TYPE, ReleaseChargePacket.STREAM_CODEC, (packet, context) -> context.enqueueWork(() -> LefontiAbilities.handleServer(packet, context)));
    }

    private static void handleServer(ReleaseChargePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!serverPlayer.getMainHandItem().isEmpty()) {
            return;
        }
        int stage = LefontiAbilities.determineChargeStage(packet.ticks());
        ServerLevel level = serverPlayer.level();
        HitResult result = serverPlayer.pick(5.0, 0.0f, false);
        if (result.getType() == HitResult.Type.BLOCK) {
            BlockHitResult hit = (BlockHitResult)result;
            BlockPos pos = hit.getBlockPos();
            Direction face = hit.getDirection();
            BlockState state = level.getBlockState(pos);
            growth.perform(level, pos, state, level.getRandom(), "entity", (Player)serverPlayer, ItemStack.EMPTY, face, stage);
        }
    }

    private static int determineChargeStage(int ticks) {
        if (ticks >= 20) {
            return 3;
        }
        if (ticks >= 10) {
            return 2;
        }
        return 1;
    }

    static {
        clientChargeTicks = 0;
        isCharging = false;
        holdTicks = 0;
    }

    public record ReleaseChargePacket(int ticks) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ReleaseChargePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"dragonights", (String)"lefonti_release_charge"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ReleaseChargePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ReleaseChargePacket::ticks, ReleaseChargePacket::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

