/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.abilities.corrupted_lefonti;

import com.j9studios.dragonights.DragonightsMod;
import com.j9studios.dragonights.GlobalReferences;
import com.j9studios.dragonights.abilities.DragoniteAbility;
import com.j9studios.dragonights.registry.ModDataMaps;
import com.j9studios.dragonights.utility.DataMapsHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class CorruptedLefontiDecayAbility
implements DragoniteAbility {
    private static final double RADIUS_MULTIPLIER = 1.0;
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_STAGE_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_STAGE_3_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_1_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_2_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_3_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_4_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_5_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_6_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_7_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_8_BLOCKS = new HashMap<Block, Block>();
    public static final Map<Block, Block> CORRUPTED_LEFONTI_RADIUS_9_BLOCKS = new HashMap<Block, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_1_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_2_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_3_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_4_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_5_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_6_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_7_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_8_TAGS = new HashMap<TagKey<Block>, Block>();
    public static final Map<TagKey<Block>, Block> CORRUPTED_LEFONTI_RADIUS_9_TAGS = new HashMap<TagKey<Block>, Block>();

    public static boolean isValidTarget(ServerLevel level, BlockPos pos, BlockState state) {
        return state.is(GlobalReferences.DragonightsIndex.BlockTags.CORRUPTED_LEFONTI_REPLACEABLE);
    }

    public static void initReplacementMaps(MinecraftServer server) {
        CORRUPTED_LEFONTI_STAGE_1_BLOCKS.clear();
        CORRUPTED_LEFONTI_STAGE_1_TAGS.clear();
        CORRUPTED_LEFONTI_STAGE_2_BLOCKS.clear();
        CORRUPTED_LEFONTI_STAGE_2_TAGS.clear();
        CORRUPTED_LEFONTI_STAGE_3_BLOCKS.clear();
        CORRUPTED_LEFONTI_STAGE_3_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_1_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_1_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_2_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_2_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_3_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_3_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_4_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_4_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_5_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_5_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_6_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_6_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_7_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_7_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_8_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_8_TAGS.clear();
        CORRUPTED_LEFONTI_RADIUS_9_BLOCKS.clear();
        CORRUPTED_LEFONTI_RADIUS_9_TAGS.clear();
        Map<String, ModDataMaps.CorruptedLefontiData> allData = DataMapsHelper.parse(server, "dragonights", "block/corrupted_lefonti_replaceables", obj -> new ModDataMaps.CorruptedLefontiData(obj.get("replaced").getAsString(), obj.get("stage").getAsInt(), obj.get("radius").getAsInt()));
        for (Map.Entry<String, ModDataMaps.CorruptedLefontiData> entry : allData.entrySet()) {
            Block block;
            String key = entry.getKey();
            ModDataMaps.CorruptedLefontiData data = entry.getValue();
            String[] parts = data.replaced().split(":", 2);
            if (parts.length != 2) {
                DragonightsMod.LOGGER.warn("The following block ID failed to load: {}", (Object)data.replaced());
                continue;
            }
            ResourceLocation replacementLoc = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            Block replacement = BuiltInRegistries.BLOCK.getOptional(replacementLoc).orElse(Blocks.AIR);
            if (key.startsWith("#")) {
                ResourceLocation tagLoc = ResourceLocation.tryParse((String)key.substring(1));
                if (tagLoc == null) continue;
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagLoc);
                switch (data.stage()) {
                    case 1: {
                        CORRUPTED_LEFONTI_STAGE_1_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 2: {
                        CORRUPTED_LEFONTI_STAGE_2_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 3: {
                        CORRUPTED_LEFONTI_STAGE_3_TAGS.put((TagKey<Block>)tag, replacement);
                    }
                }
                switch (data.radius()) {
                    case 1: {
                        CORRUPTED_LEFONTI_RADIUS_1_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 2: {
                        CORRUPTED_LEFONTI_RADIUS_2_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 3: {
                        CORRUPTED_LEFONTI_RADIUS_3_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 4: {
                        CORRUPTED_LEFONTI_RADIUS_4_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 5: {
                        CORRUPTED_LEFONTI_RADIUS_5_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 6: {
                        CORRUPTED_LEFONTI_RADIUS_6_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 7: {
                        CORRUPTED_LEFONTI_RADIUS_7_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 8: {
                        CORRUPTED_LEFONTI_RADIUS_8_TAGS.put((TagKey<Block>)tag, replacement);
                        break;
                    }
                    case 9: {
                        CORRUPTED_LEFONTI_RADIUS_9_TAGS.put((TagKey<Block>)tag, replacement);
                    }
                }
                continue;
            }
            ResourceLocation blockLoc = ResourceLocation.tryParse((String)key);
            if (blockLoc == null || (block = BuiltInRegistries.BLOCK.getOptional(blockLoc).orElse(Blocks.AIR)) == Blocks.AIR) continue;
            switch (data.stage()) {
                case 1: {
                    CORRUPTED_LEFONTI_STAGE_1_BLOCKS.put(block, replacement);
                    break;
                }
                case 2: {
                    CORRUPTED_LEFONTI_STAGE_2_BLOCKS.put(block, replacement);
                    break;
                }
                case 3: {
                    CORRUPTED_LEFONTI_STAGE_3_BLOCKS.put(block, replacement);
                }
            }
            switch (data.radius()) {
                case 1: {
                    CORRUPTED_LEFONTI_RADIUS_1_BLOCKS.put(block, replacement);
                    break;
                }
                case 2: {
                    CORRUPTED_LEFONTI_RADIUS_2_BLOCKS.put(block, replacement);
                    break;
                }
                case 3: {
                    CORRUPTED_LEFONTI_RADIUS_3_BLOCKS.put(block, replacement);
                    break;
                }
                case 4: {
                    CORRUPTED_LEFONTI_RADIUS_4_BLOCKS.put(block, replacement);
                    break;
                }
                case 5: {
                    CORRUPTED_LEFONTI_RADIUS_5_BLOCKS.put(block, replacement);
                    break;
                }
                case 6: {
                    CORRUPTED_LEFONTI_RADIUS_6_BLOCKS.put(block, replacement);
                    break;
                }
                case 7: {
                    CORRUPTED_LEFONTI_RADIUS_7_BLOCKS.put(block, replacement);
                    break;
                }
                case 8: {
                    CORRUPTED_LEFONTI_RADIUS_8_BLOCKS.put(block, replacement);
                    break;
                }
                case 9: {
                    CORRUPTED_LEFONTI_RADIUS_9_BLOCKS.put(block, replacement);
                }
            }
        }
        DragonightsMod.LOGGER.info("Corrupted lefonti replacement blocks stage 1: {} blocks, {} tags", (Object)CORRUPTED_LEFONTI_STAGE_1_BLOCKS.size(), (Object)CORRUPTED_LEFONTI_STAGE_1_TAGS.size());
        DragonightsMod.LOGGER.info("Corrupted lefonti replacement blocks stage 2: {} blocks, {} tags", (Object)CORRUPTED_LEFONTI_STAGE_2_BLOCKS.size(), (Object)CORRUPTED_LEFONTI_STAGE_2_TAGS.size());
        DragonightsMod.LOGGER.info("Corrupted lefonti replacement blocks stage 3: {} blocks, {} tags", (Object)CORRUPTED_LEFONTI_STAGE_3_BLOCKS.size(), (Object)CORRUPTED_LEFONTI_STAGE_3_TAGS.size());
    }

    private Block fetchReplacementBlock(BlockState state, int stage) {
        Block block = state.getBlock();
        if (stage >= 1) {
            if (CORRUPTED_LEFONTI_STAGE_1_BLOCKS.containsKey(block)) {
                return CORRUPTED_LEFONTI_STAGE_1_BLOCKS.get(block);
            }
            for (TagKey<Block> tag : CORRUPTED_LEFONTI_STAGE_1_TAGS.keySet()) {
                if (!state.is(tag)) continue;
                return CORRUPTED_LEFONTI_STAGE_1_TAGS.get(tag);
            }
        }
        if (stage >= 2) {
            if (CORRUPTED_LEFONTI_STAGE_2_BLOCKS.containsKey(block)) {
                return CORRUPTED_LEFONTI_STAGE_2_BLOCKS.get(block);
            }
            for (TagKey<Block> tag : CORRUPTED_LEFONTI_STAGE_2_TAGS.keySet()) {
                if (!state.is(tag)) continue;
                return CORRUPTED_LEFONTI_STAGE_2_TAGS.get(tag);
            }
        }
        if (stage >= 3) {
            if (CORRUPTED_LEFONTI_STAGE_3_BLOCKS.containsKey(block)) {
                return CORRUPTED_LEFONTI_STAGE_3_BLOCKS.get(block);
            }
            for (TagKey<Block> tag : CORRUPTED_LEFONTI_STAGE_3_TAGS.keySet()) {
                if (!state.is(tag)) continue;
                return CORRUPTED_LEFONTI_STAGE_3_TAGS.get(tag);
            }
        }
        return null;
    }

    private void replaceSingleBlock(ServerLevel level, BlockPos pos, Block newBlock, int stage, BlockState oldState) {
        BlockState newState = newBlock.defaultBlockState();
        for (Property property : oldState.getProperties()) {
            if (!newState.hasProperty(property)) continue;
            newState = (BlockState)newState.setValue(property, oldState.getValue(property));
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)oldState));
        SoundType soundType = newBlock.getSoundType(newState, (LevelReader)level, pos, null);
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.setBlock(pos, newState, 3);
        float particleHeight = newState.isSolidRender() ? 1.1f : 0.1f;
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)((float)pos.getY() + particleHeight), (double)pos.getZ() + 0.5, 15, 0.25, 0.1, 0.25, 0.05);
    }

    private int fetchBlockStage(BlockState state) {
        block11: {
            block10: {
                Block block;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block = state.getBlock();
                                if (CORRUPTED_LEFONTI_STAGE_1_BLOCKS.containsKey(block)) break block6;
                                if (!CORRUPTED_LEFONTI_STAGE_1_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) break block7;
                            }
                            return 1;
                        }
                        if (CORRUPTED_LEFONTI_STAGE_2_BLOCKS.containsKey(block)) break block8;
                        if (!CORRUPTED_LEFONTI_STAGE_2_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) break block9;
                    }
                    return 2;
                }
                if (CORRUPTED_LEFONTI_STAGE_3_BLOCKS.containsKey(block)) break block10;
                if (!CORRUPTED_LEFONTI_STAGE_3_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) break block11;
            }
            return 3;
        }
        return 1;
    }

    private int fetchBlockRadius(BlockState state) {
        Block block = state.getBlock();
        block11: for (int radius = 1; radius <= 9; ++radius) {
            switch (radius) {
                case 1: {
                    if (!CORRUPTED_LEFONTI_RADIUS_1_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_1_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 1;
                }
                case 2: {
                    if (!CORRUPTED_LEFONTI_RADIUS_2_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_2_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 2;
                }
                case 3: {
                    if (!CORRUPTED_LEFONTI_RADIUS_3_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_3_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 3;
                }
                case 4: {
                    if (!CORRUPTED_LEFONTI_RADIUS_4_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_4_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 4;
                }
                case 5: {
                    if (!CORRUPTED_LEFONTI_RADIUS_5_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_5_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 5;
                }
                case 6: {
                    if (!CORRUPTED_LEFONTI_RADIUS_6_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_6_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 6;
                }
                case 7: {
                    if (!CORRUPTED_LEFONTI_RADIUS_7_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_7_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 7;
                }
                case 8: {
                    if (!CORRUPTED_LEFONTI_RADIUS_8_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_8_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 8;
                }
                case 9: {
                    if (!CORRUPTED_LEFONTI_RADIUS_9_BLOCKS.containsKey(block)) {
                        if (!CORRUPTED_LEFONTI_RADIUS_9_TAGS.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue block11;
                    }
                    return 9;
                }
            }
        }
        return 1;
    }

    private int calculateEffectiveRadius(BlockState state, int passStage) {
        int blockStage = this.fetchBlockStage(state);
        int blockRadius = this.fetchBlockRadius(state);
        if (passStage < blockStage) {
            return 0;
        }
        int stageMultiplier = passStage - blockStage + 1;
        return (int)((double)(blockRadius * stageMultiplier) * 1.0);
    }

    private boolean replaceBlock(ServerLevel level, BlockPos centerPos, int stage) {
        boolean replaced = false;
        int maxRadius = 9;
        for (int dx = -maxRadius; dx <= maxRadius; ++dx) {
            for (int dy = -maxRadius; dy <= maxRadius; ++dy) {
                for (int dz = -maxRadius; dz <= maxRadius; ++dz) {
                    BlockPos pos = centerPos.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(pos);
                    Block replacement = this.fetchReplacementBlock(state, stage);
                    if (replacement == null || state.is(replacement)) continue;
                    int effectiveRadius = this.calculateEffectiveRadius(state, stage);
                    boolean inside = false;
                    switch (effectiveRadius) {
                        case 1: {
                            inside = dx == 0 && dy == 0 && dz == 0;
                            break;
                        }
                        case 2: {
                            inside = Math.abs(dx) + Math.abs(dy) + Math.abs(dz) <= 1;
                            break;
                        }
                        case 3: {
                            inside = Math.abs(dx) <= 1 && Math.abs(dy) <= 1 && Math.abs(dz) <= 1;
                            break;
                        }
                        case 4: {
                            inside = Math.abs(dx) + Math.abs(dy) + Math.abs(dz) <= 2 || centerPos.distSqr((Vec3i)pos) <= 9.0;
                            break;
                        }
                        default: {
                            boolean bl = inside = centerPos.distSqr((Vec3i)pos) <= (double)(effectiveRadius * effectiveRadius);
                        }
                    }
                    if (!inside || !state.is(GlobalReferences.DragonightsIndex.BlockTags.CORRUPTED_LEFONTI_REPLACEABLE)) continue;
                    this.replaceSingleBlock(level, pos, replacement, stage, state);
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    public void perform(ServerLevel level, BlockPos centerPos, BlockState state, RandomSource random, String sourceType, Player player, ItemStack handStack, Direction clickedFace, int stage) {
        if (!DragoniteAbility.canActivate(level, centerPos, state, sourceType, player)) {
            return;
        }
        if (state == null || stage < 1) {
            stage = 1;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            if (stage >= 3 && Objects.equals(sourceType, "block")) {
                serverLevel.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, centerPos.getCenter(), Vec2.ZERO, serverLevel, 4, "", (Component)Component.literal((String)""), serverLevel.getServer(), null).withSuppressedOutput(), "fillbiome ~-" + stage + " ~-" + stage + " ~-" + stage + " ~" + stage + " ~" + stage + " ~" + stage + " dragonights:corrupted_lefonti_wasteland");
            }
        }
        if (this.replaceBlock(level, centerPos, stage)) {
            return;
        }
        if ("item".equals(sourceType) && player != null && handStack != null) {
            if (handStack.isDamageableItem()) {
                handStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            } else {
                handStack.shrink(1);
            }
        }
    }
}

