/*
 * Decompiled with CFR 0.152.
 */
package com.j9studios.dragonights.events.items;

import com.j9studios.dragonights.registry.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class AxeOozeHandler {
    private static final Map<Block, Block> DEOOZEABLES = new HashMap<Block, Block>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof AxeItem)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block originalBlock = DEOOZEABLES.get(state.getBlock());
        if (originalBlock != null) {
            BlockState newState = originalBlock.withPropertiesOf(state);
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ResourceLocation advId = ResourceLocation.tryParse((String)"dragonights:dragonights/ooze_off");
                if (advId != null) {
                    serverPlayer.getServer().getAdvancements().getAllAdvancements().stream().filter(adv -> adv.id().equals((Object)advId)).forEach(adv -> serverPlayer.getAdvancements().getOrStartProgress(adv).getRemainingCriteria().forEach(criterion -> serverPlayer.getAdvancements().award(adv, criterion)));
                }
                level.setBlock(pos, newState, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            }
            level.playSound((Entity)player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.hurtAndBreak(1, (LivingEntity)player, event.getHand());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (level instanceof ServerLevel) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.4, 0.4, 0.4, 0.05);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    static {
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_CLUSTER.get(), (Block)ModBlocks.LEFONTI_CLUSTER.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_BLOCK.get(), (Block)ModBlocks.LEFONTI_BLOCK.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_LEFONTI_BLOCK.get(), (Block)ModBlocks.POLISHED_LEFONTI_BLOCK.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_LEFONTI_STAIRS.get(), (Block)ModBlocks.POLISHED_LEFONTI_STAIRS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_LEFONTI_SLAB.get(), (Block)ModBlocks.POLISHED_LEFONTI_SLAB.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_BRICKS.get(), (Block)ModBlocks.LEFONTI_BRICKS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_BRICK_STAIRS.get(), (Block)ModBlocks.LEFONTI_BRICK_STAIRS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_BRICK_SLAB.get(), (Block)ModBlocks.LEFONTI_BRICK_SLAB.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_LEFONTI_BRICK_WALL.get(), (Block)ModBlocks.LEFONTI_BRICK_WALL.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CHISELED_LEFONTI_BRICKS.get(), (Block)ModBlocks.CHISELED_LEFONTI_BRICKS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_CLUSTER.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_CLUSTER.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BLOCK.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_BLOCK.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_BLOCK.get(), (Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_BLOCK.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_STAIRS.get(), (Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_STAIRS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_POLISHED_CORRUPTED_LEFONTI_SLAB.get(), (Block)ModBlocks.POLISHED_CORRUPTED_LEFONTI_SLAB.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICKS.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_BRICKS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_STAIRS.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_STAIRS.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_SLAB.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_SLAB.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CORRUPTED_LEFONTI_BRICK_WALL.get(), (Block)ModBlocks.CORRUPTED_LEFONTI_BRICK_WALL.get());
        DEOOZEABLES.put((Block)ModBlocks.OOZED_CHISELED_CORRUPTED_LEFONTI_BRICKS.get(), (Block)ModBlocks.CHISELED_CORRUPTED_LEFONTI_BRICKS.get());
    }
}

