/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.unitweaks.tweaks.controls;

import java.awt.Color;
import java.util.ArrayList;
import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.tweaks.controls.DefaultKeys;
import net.danygames2014.unitweaks.tweaks.controls.KeybindListWidget;
import net.danygames2014.unitweaks.util.gui.CallbackButtonWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_181;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_322;
import net.minecraft.class_33;
import net.minecraft.class_386;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Environment(value=EnvType.CLIENT)
public class ControlsScreen
extends class_32 {
    public class_32 parent;
    public String title = "Controls";
    public String debugText = "";
    public class_322 options;
    public final class_300 translations;
    public ArrayList<class_33> keybindButtons;
    public KeybindListWidget keybindListWidget;
    public class_181 searchTextField;
    int searchX;
    int searchY;
    int searchWidth;
    int searchHeight;
    public class_33 doneButton;
    public class_33 stepAssist;
    public class_33 selectedButton;
    private final ArrayList<KeybindEntry> keybinds = new ArrayList();
    public ArrayList<KeybindEntry> filteredKeybinds = new ArrayList();

    public ControlsScreen(class_32 parent, class_322 gameOptions) {
        this.parent = parent;
        this.options = gameOptions;
        this.translations = class_300.method_992();
        this.keybindButtons = new ArrayList(20);
    }

    public void method_119() {
        this.keybindListWidget = new KeybindListWidget(this, this.field_151, this.options);
        this.searchTextField = new class_181((class_32)this, this.field_156, this.field_152 / 2 - 110, this.field_153 - 30, 100, 20, "");
        this.searchTextField.method_1878(32);
        this.searchX = this.field_152 / 2 - 110;
        this.searchY = this.field_153 - 30;
        this.searchWidth = 100;
        this.searchHeight = 20;
        this.doneButton = new class_33(1000, this.field_152 / 2 + 10, this.field_153 - 30, 100, 20, "Done");
        this.field_154.add(this.doneButton);
        this.stepAssist = new class_33(1001, this.field_152 / 2 + 10, 10, 100, 20, "Step Assist: OFF");
        if (this.field_151.field_2804 == null) {
            this.stepAssist.field_1374 = false;
        }
        this.field_154.add(this.stepAssist);
        this.initKeybinds();
        this.filterKeybinds();
        this.refreshKeyLabels();
        this.refreshButtonLabels();
    }

    public void initKeybinds() {
        this.keybindButtons.clear();
        this.keybinds.clear();
        for (int i = 0; i < this.options.field_1478.length; ++i) {
            class_386 keyBinding = this.options.field_1478[i];
            class_33 keyButton = new class_33(i, -1, -1, 100, 20, Keyboard.getKeyName((int)keyBinding.field_2381));
            this.keybinds.add(new KeybindEntry(this, keyButton, keyBinding));
            this.keybindButtons.add(keyButton);
        }
    }

    public void filterKeybinds() {
        this.filteredKeybinds.clear();
        String searchTerm = this.searchTextField.method_1876().toLowerCase();
        for (KeybindEntry item : this.keybinds) {
            if (!this.translations.method_993(item.keyBinding.field_2380).toLowerCase().contains(searchTerm)) continue;
            this.filteredKeybinds.add(item);
        }
    }

    public void refreshKeyLabels() {
        for (KeybindEntry keybindEntry : this.filteredKeybinds) {
            String formatting = "\u00a7f";
            for (int j = 0; j < this.options.field_1478.length; ++j) {
                if (this.options.field_1478[j].field_2380.equals(keybindEntry.keyBinding.field_2380) || this.options.field_1478[j].field_2381 != keybindEntry.keyBinding.field_2381 || this.options.field_1478[j].field_2380.equals("key.unitweaks.dismount") || keybindEntry.keyBinding.field_2380.equals("key.unitweaks.dismount") || this.options.field_1478[j].field_2381 == 0 && keybindEntry.keyBinding.field_2381 == 0) continue;
                formatting = "\u00a7c";
            }
            keybindEntry.keyButton.field_1372 = formatting + Keyboard.getKeyName((int)keybindEntry.keyBinding.field_2381) + "\u00a7f";
        }
    }

    public void refreshButtonLabels() {
        this.stepAssist.field_1372 = UniTweaks.FEATURES_CONFIG.stepAssist != false ? "Step Assist: ON" : "Step Assist: OFF";
    }

    public void method_131() {
        super.method_131();
        float dWheel = Mouse.getDWheel();
        if (dWheel != 0.0f) {
            this.keybindListWidget.scroll(-(dWheel / 10.0f));
        }
    }

    protected void method_124(int mouseX, int mouseY, int button) {
        super.method_124(mouseX, mouseY, button);
        this.selectedButton = null;
        this.refreshKeyLabels();
        this.searchTextField.method_1879(mouseX, mouseY, button);
        if (button == 1) {
            this.filterKeybinds();
        }
        this.mouseClickedKeybind(mouseX, mouseY, button);
    }

    public void mouseClickedKeybind(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (mouseY < 40 || mouseY > this.field_153 - 40) {
            return;
        }
        for (KeybindEntry keybindEntry : this.filteredKeybinds) {
            class_33 button = keybindEntry.keyButton;
            if (!button.method_1189(this.field_151, mouseX, mouseY) || !(this.keybindListWidget.getScroll() < (float)(button.field_1373 * 20 + 24))) continue;
            this.field_151.field_2766.method_2009("random.click", 1.0f, 1.0f);
            this.method_120(button);
            return;
        }
    }

    protected void method_117(char character, int keyCode) {
        if (this.searchTextField.field_2420) {
            this.searchTextField.method_1877(character, keyCode);
            this.filterKeybinds();
            return;
        }
        for (KeybindEntry item : this.filteredKeybinds) {
            if (item.keyButton != this.selectedButton) continue;
            item.keyBinding.field_2381 = keyCode == 1 ? 0 : keyCode;
            this.selectedButton = null;
            this.refreshKeyLabels();
            this.options.method_1231();
            return;
        }
    }

    protected void method_120(class_33 button) {
        if (button.field_1373 == 1000) {
            this.field_151.method_2112(this.parent);
        } else if (button.field_1373 == 1001) {
            UniTweaks.FEATURES_CONFIG.stepAssist = UniTweaks.FEATURES_CONFIG.stepAssist == false;
            GlassYamlFile yamlFile = new GlassYamlFile();
            yamlFile.set("stepAssist", (Object)UniTweaks.FEATURES_CONFIG.stepAssist);
            try {
                GCAPI.reloadConfig((String)"unitweaks:features", (GlassYamlFile)yamlFile);
            }
            catch (Exception e) {
                UniTweaks.LOGGER.error("Failed to reload config", (Throwable)e);
            }
            this.refreshButtonLabels();
        } else if (this.keybindButtons.contains(button)) {
            this.selectedButton = button;
            button.field_1372 = "> " + button.field_1372 + " <";
        } else if (button instanceof CallbackButtonWidget) {
            CallbackButtonWidget callbackButton = (CallbackButtonWidget)button;
            callbackButton.doAction();
        }
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        this.method_134();
        this.keybindListWidget.method_1256(mouseX, mouseY, delta);
        this.method_1937(this.field_156, this.title, 10, 10, Color.white.getRGB());
        this.method_1937(this.field_156, this.debugText, 10, 20, Color.white.getRGB());
        this.searchTextField.method_1883();
        this.doneButton.method_1186(this.field_151, mouseX, mouseY);
        this.stepAssist.method_1186(this.field_151, mouseX, mouseY);
    }

    public static class KeybindEntry {
        public final class_33 keyButton;
        public class_386 keyBinding;
        public class_33 resetButton;
        public final int defaultKeybind;
        public final ControlsScreen parent;

        public KeybindEntry(ControlsScreen parent, class_33 keyButton, class_386 keyBinding) {
            this.parent = parent;
            this.keyButton = keyButton;
            this.keyBinding = keyBinding;
            this.defaultKeybind = DefaultKeys.getDefaultKeybind(keyBinding);
            this.init();
        }

        public void init() {
            this.resetButton = new CallbackButtonWidget(-1, -1, 50, 20, "Reset", this::resetToDefault);
            this.parent.field_154.add(this.resetButton);
        }

        private void resetToDefault(Void unused) {
            this.keyBinding.field_2381 = this.defaultKeybind;
            this.parent.refreshKeyLabels();
            this.parent.options.method_1231();
        }
    }
}

