/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.unitweaks.mixin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class UniTweaksMixinPlugin
implements IMixinConfigPlugin {
    public static GlassYamlFile ui_config;
    public static ArrayList<String> nonStationMixins;

    public void onLoad(String mixinPackage) {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "unitweaks/userinterface.yml");
        ui_config = new GlassYamlFile();
        try {
            ui_config.load(file);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.cloudheight.WorldRendererMixin", ui_config, "videoSettingsConfig.cloudHeightSlider")) {
            return false;
        }
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.fpslimitslider.class_555Mixin", ui_config, "videoSettingsConfig.fpsLimitSlider")) {
            return false;
        }
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.guiscaleslider.ScreenScalerMixin", ui_config, "videoSettingsConfig.guiScaleSlider")) {
            return false;
        }
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.renderdistance.class555Mixin", ui_config, "videoSettingsConfig.renderDistanceSlider")) {
            return false;
        }
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.renderdistance.MinecraftMixin", ui_config, "videoSettingsConfig.renderDistanceSlider")) {
            return false;
        }
        if (UniTweaksMixinPlugin.isDisabled(mixinClassName, "tweaks.renderdistance.WorldRendererMixin", ui_config, "videoSettingsConfig.renderDistanceSlider")) {
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("stationapi") && nonStationMixins.contains(mixinClassName)) {
            UniTweaks.LOGGER.info("StationAPI Detected. Skipping mixin " + mixinClassName);
            return false;
        }
        return true;
    }

    public static boolean isDisabled(String mixinClassName, String mixinName, GlassYamlFile config, String configBool) {
        if (config.contains(configBool)) {
            return mixinClassName.equals("net.danygames2014.unitweaks.mixin." + mixinName) && !config.getBoolean(configBool);
        }
        return false;
    }

    static {
        nonStationMixins = new ArrayList<String>(){
            {
                this.add("net.danygames2014.unitweaks.mixin.bugfixes.droppeditemfix.ItemRendererMixin");
                this.add("net.danygames2014.unitweaks.mixin.hooks.GameOptionsMixin");
                this.add("net.danygames2014.unitweaks.mixin.hooks.MinecraftMixin");
                this.add("net.danygames2014.unitweaks.mixin.tweaks.mipmap.TextureManagerMixin");
                this.add("net.danygames2014.unitweaks.mixin.tweaks.recipes.FurnaceBlockEntityMixin");
                this.add("net.danygames2014.unitweaks.mixin.tweaks.recipes.BlockMixin");
            }
        };
    }
}

