/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hrodebert.mots.Client.CappyScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class CappyGetAStandScreen
extends Screen {
    private final List<String> paragraphs = Arrays.asList("To obtain a Stand, you'll first need to locate a meteorite. These crash randomly in desert biomes, so stay alert while exploring.", "At the center of the meteorite, you'll find a glowing block \u2014 the Meteorite Core. Mine it, but be careful \u2014 it's rare and important.", "Next, smelt the Meteorite Core in a furnace. Once refined, you\u2019ll use it to craft a powerful artifact: the Stand Arrow.", "Craft the Stand Arrow using the normal stand arrow and put the stand core instead of the flint", "After crafting it, use the Stand Arrow to stab yourself. If you survive the process, your Stand will awaken!", "Each Stand is different, and starts off weak. The more you use it, the stronger it becomes through experience.", "Some rare Stands can't be obtained with the arrow and require special items found in pyramid structures.", "To get **Tusk**, you must find and use the **Saint's Arm**, which can be found inside desert pyramid chests.", "**D4C** is unlocked using the **Heart of the Saint's Corpse**, another rare item hidden in pyramid ruins.", "To obtain **Wonder of U**, you must consume a **Locacaca fruit** \u2014 though the chance of gaining the Stand is very low.", "Experiment, explore, and survive. Not every path to power is the same, but each one is worth the risk.");
    private int currentPage = 0;
    private final int paragraphsPerPage = 3;

    public CappyGetAStandScreen() {
        super((Component)Component.literal((String)"Cappy Introduction"));
    }

    protected void init() {
        int centerX = this.width / 2;
        int bottomY = this.height - 40;
        int buttonWidth = 60;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> Minecraft.getInstance().setScreen((Screen)new CappyScreen())).bounds(centerX - 150, bottomY, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(centerX - 35, bottomY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2192"), b -> {
            if ((this.currentPage + 1) * 3 < this.paragraphs.size()) {
                ++this.currentPage;
            }
        }).bounds(centerX + 35, bottomY, buttonWidth, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderPanel(graphics);
        int x = 40;
        int y = 30;
        int lineHeight = 12;
        int paragraphSpacing = 10;
        List<String> currentParagraphs = this.getParagraphsForPage(this.currentPage);
        for (String paragraph : currentParagraphs) {
            List<String> lines = this.wrapText(paragraph, this.width - 80);
            for (String line : lines) {
                graphics.drawString(this.font, line, x, y, FastColor.ARGB32.color((int)255, (int)255, (int)255));
                y += lineHeight;
            }
            y += paragraphSpacing;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    private List<String> getParagraphsForPage(int page) {
        int start = page * 3;
        int end = Math.min(start + 3, this.paragraphs.size());
        return this.paragraphs.subList(start, end);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(line) + word) < maxWidth) {
                line.append(word).append(" ");
                continue;
            }
            result.add(line.toString().trim());
            line = new StringBuilder(word + " ");
        }
        if (!line.toString().isEmpty()) {
            result.add(line.toString().trim());
        }
        return result;
    }

    private void renderPanel(GuiGraphics graphics) {
        int padding = 20;
        int panelWidth = this.width - padding * 2;
        int panelHeight = this.height - padding * 2;
        int x1 = padding;
        int y1 = padding;
        int x2 = x1 + panelWidth;
        int y2 = y1 + panelHeight;
        graphics.fill(x1 - 2, y1 - 2, x2 + 2, y2 + 2, FastColor.ARGB32.color((int)255, (int)30, (int)30, (int)30));
        graphics.fill(x1, y1, x2, y2, FastColor.ARGB32.color((int)220, (int)50, (int)50, (int)50));
    }
}

