/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hrodebert.mots.Client.CappyScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class CappyIntroScreen
extends Screen {
    private final List<String> paragraphs = Arrays.asList("Hey there, newcomer. You\u2019re not from around here, huh? Well, listen up \u2014 things work a bit differently in this world.", "There are these things called Stands \u2014 15 unique ones. Each has their own stamina, skills, and personality. You won\u2019t start strong. In fact, you\u2019ll feel weak at first. But as you fight, train, and master your abilities, you\u2019ll get stronger.", "Want your time stop to last longer? Use it more. Want to hit harder? Get in close and punch a lot.", "Stands have modes: Normal, Remote, and Sentry. Control them directly, or let them fight while you stay safe. They can hit enemies, break blocks, and evolve over time.", "But you\u2019re not the only one with power... You\u2019ll face enemy Stand users, powerful bosses, and uncover quests and secrets across the land.", "Oh, and one more thing \u2014 Spin and Vampirism are real. And very, very dangerous.", "Stay sharp. This journey\u2019s just beginning.");
    private int currentPage = 0;
    private final int paragraphsPerPage = 3;

    public CappyIntroScreen() {
        super((Component)Component.literal((String)"Cappy Introduction"));
    }

    protected void init() {
        int centerX = this.width / 2;
        int bottomY = this.height - 40;
        int buttonWidth = 60;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> Minecraft.getInstance().setScreen((Screen)new CappyScreen())).bounds(centerX - 150, bottomY, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(centerX - 35, bottomY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2192"), b -> {
            if ((this.currentPage + 1) * 3 < this.paragraphs.size()) {
                ++this.currentPage;
            }
        }).bounds(centerX + 35, bottomY, buttonWidth, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderPanel(graphics);
        int x = 40;
        int y = 30;
        int lineHeight = 12;
        int paragraphSpacing = 10;
        List<String> currentParagraphs = this.getParagraphsForPage(this.currentPage);
        for (String paragraph : currentParagraphs) {
            List<String> lines = this.wrapText(paragraph, this.width - 80);
            for (String line : lines) {
                graphics.drawString(this.font, line, x, y, FastColor.ARGB32.color((int)255, (int)255, (int)255));
                y += lineHeight;
            }
            y += paragraphSpacing;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    private List<String> getParagraphsForPage(int page) {
        int start = page * 3;
        int end = Math.min(start + 3, this.paragraphs.size());
        return this.paragraphs.subList(start, end);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(line) + word) < maxWidth) {
                line.append(word).append(" ");
                continue;
            }
            result.add(line.toString().trim());
            line = new StringBuilder(word + " ");
        }
        if (!line.toString().isEmpty()) {
            result.add(line.toString().trim());
        }
        return result;
    }

    private void renderPanel(GuiGraphics graphics) {
        int padding = 20;
        int panelWidth = this.width - padding * 2;
        int panelHeight = this.height - padding * 2;
        int x1 = padding;
        int y1 = padding;
        int x2 = x1 + panelWidth;
        int y2 = y1 + panelHeight;
        graphics.fill(x1 - 2, y1 - 2, x2 + 2, y2 + 2, FastColor.ARGB32.color((int)255, (int)30, (int)30, (int)30));
        graphics.fill(x1, y1, x2, y2, FastColor.ARGB32.color((int)220, (int)50, (int)50, (int)50));
    }
}

