/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import net.hrodebert.mots.Client.CappyGetAStandScreen;
import net.hrodebert.mots.Client.CappyIntroScreen;
import net.hrodebert.mots.Client.CappyItemInfo;
import net.hrodebert.mots.Client.CappySkillsExplenation;
import net.hrodebert.mots.Client.EvolvingStands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class CappyScreen
extends Screen {
    public CappyScreen() {
        super((Component)Component.literal((String)"Cappy"));
    }

    public static void openScreen() {
        Minecraft.getInstance().setScreen((Screen)new CappyScreen());
    }

    protected void init() {
        int panelWidth = 200;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int startY = (this.height - (buttonHeight + buttonSpacing) * 4) / 2;
        int centerX = this.width / 2;
        this.addCenteredButton("Introduction", startY, b -> Minecraft.getInstance().setScreen((Screen)new CappyIntroScreen()));
        this.addCenteredButton("How to obtain a stand", startY + 30, b -> Minecraft.getInstance().setScreen((Screen)new CappyGetAStandScreen()));
        this.addCenteredButton("Mod items", startY + 60, b -> Minecraft.getInstance().setScreen((Screen)new CappyItemInfo()));
        this.addCenteredButton("How abilities work", startY + 90, b -> Minecraft.getInstance().setScreen((Screen)new CappySkillsExplenation()));
        this.addCenteredButton("Evolving stands", startY + 120, b -> Minecraft.getInstance().setScreen((Screen)new EvolvingStands()));
    }

    private void addCenteredButton(String text, int y, Button.OnPress onPress) {
        int buttonWidth = 200;
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)text), (Button.OnPress)onPress).bounds(centerX - buttonWidth / 2, y, buttonWidth, 20).build());
    }

    private void renderPanel(GuiGraphics graphics) {
        int padding = 20;
        int panelWidth = this.width - padding * 2;
        int panelHeight = this.height - padding * 2;
        int x1 = padding;
        int y1 = padding;
        int x2 = x1 + panelWidth;
        int y2 = y1 + panelHeight;
        graphics.fill(x1 - 2, y1 - 2, x2 + 2, y2 + 2, FastColor.ARGB32.color((int)255, (int)30, (int)30, (int)30));
        graphics.fill(x1, y1, x2, y2, FastColor.ARGB32.color((int)220, (int)50, (int)50, (int)50));
    }

    private void renderTitle(GuiGraphics graphics) {
        String title = "Tutorials";
        int titleX = this.width / 2 - this.font.width(title) / 2;
        int titleY = 30;
        graphics.drawString(this.font, title, titleX, titleY, FastColor.ARGB32.color((int)255, (int)255, (int)255));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderPanel(graphics);
        this.renderTitle(graphics);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }
}

