/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hrodebert.mots.Client.CappyScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class CappySkillsExplenation
extends Screen {
    private final List<String> paragraphs = Arrays.asList("**The World**: Chop (2pts, 2s) \u2013 Quick strike with light stun. Finisher (4pts, 3s) \u2013 Strong blow with knockback. Barrage (3pts, 1s) \u2013 Fast punches, no stun. Time Stop (20s) \u2013 Freeze time briefly.", "**Killer Queen**: Plant (2pts, 6s) \u2013 Make entity explosive. Ignite (2s) \u2013 Detonate explosives. Sheer Heart Attack (3pts, 10s) \u2013 Autonomous explosive tank. Explosion Barrage (4pts) \u2013 Triple explosion plus plant. Bite the Dust (6pts) \u2013 Save and revert time. Item Bomb (3pts) \u2013 Turn items into bombs.", "**Crazy Diamond**: Chop (2pts, 2s) \u2013 Break blocks, small damage. Finisher (4pts, 2s) \u2013 Strong block-breaking attack. Ground Kick (5pts, 2s) \u2013 AoE knockback and damage. Barrage (6pts, 1s) \u2013 Stun and break blocks. Mode Switch (0pts) \u2013 Toggle Break/Heal mode. Replace Broken Blocks (5pts) \u2013 Restores previous terrain.", "**Golden Experience**: Finisher (4pts) \u2013 Knockback punch. Soul Punch (6pts) \u2013 Applies debuffs. Barrage (3pts) \u2013 Fast punches. Spawn Bee Army (3pts) \u2013 Summon attack swarm. Create Tree (4pts) \u2013 Tree launch + invulnerability. Heal (6pts) \u2013 Heal allies on hit. Self Heal (6pts, crouch) \u2013 Heal self. Turn Item Into Frog (3pts) \u2013 Friendly frog minion. Set Frog Target Position (0pts) \u2013 Command frog.", "**King Crimson**: Chop (2pts, 2s) \u2013 Light stun hit. Impale (4pts, 3s) \u2013 Medium stun, impales target. Time Erasure (4pts, 20s) \u2013 Evade and reset positions. Epitaph (2pts, 20s) \u2013 Auto-evade incoming damage.", "**Whitesnake**: Barrage \u2013 Flurry of punches. Finisher \u2013 Knockback attack. Spit \u2013 Launch stun gas. Toxin Release \u2013 AoE sleep poison. Remove Memory Disk \u2013 Make mobs brain-dead. Remove Stand Disk \u2013 Kill to extract Stand disk.", "**C-Moon**: Uppercut (3pts, 5s) \u2013 Launch enemy. Arm Crusher (4pts, 5s) \u2013 Heavy stun. Gravity Repulsion (2pts, 4s) \u2013 Push all entities/projectiles. Gravity Inversion (3pts, 4s) \u2013 Flip enemy gravity.", "**Made in Heaven**: Chop (2pts, 2s) \u2013 Fast stun. Impale (4pts, 3s) \u2013 Strong impale. Stand Jump (2pts, 2s) \u2013 Leap back. Acceleration (20pts, 300s) \u2013 Time speeds up, gain invincibility and extreme combat boosts. Time Dilatation \u2013 View slowed world while moving at full speed.", "**Diver Down**: Disfigurative Chop (4pts, 3s) \u2013 Alters targets or launches them. Finisher (4pts, 5s) \u2013 Strong impale + AoE knockback. Storage Mode \u2013 Absorb kinetic energy. Release Kinetic Energy \u2013 Massive true damage release.", "**Weather Report**: Chop (2pts, 2s) \u2013 Basic melee. Finisher (4pts, 5s) \u2013 Heavy impale. Wind Gust (5pts, 5s) \u2013 Jump/slow-fall or blast foes. Heavy Rain (5pts, 7s) \u2013 AoE rain damage. Oxygen Control \u2013 Switch between 5 oxygen states with effects from speed to suffocation.", "**D4C (Dirty Deeds Done Dirt Cheap)**: Chop (2pts, 2s) \u2013 Light melee. Finisher (4pts, 3s) \u2013 Knockback attack. Dimension Travel (4pts, 10s) \u2013 Teleport to parallel world with allies. Dimensional Clone (4pts, 10s) \u2013 Spawn clone. Clone Swap (5s) \u2013 Switch places. Clone Heal (6pts, 10s) \u2013 Replace clone to restore health.", "**Tusk**: Shoot Nail (1pt, 0.25s) \u2013 High-speed projectile. Nail Slash (1pt, 5s) \u2013 Melee slash. Triple Shoot (3pts, 1.25s) \u2013 Rapid nails. Enter Wormhole (1pt, 3s) \u2013 Become a wormhole. Spin Finisher (3pts, 0.4s) \u2013 Strong finisher. Wormhole Uppercut (3pts, 4s) \u2013 Teleport uppercut. Uppercut (2pts, 0.25s) \u2013 Launching punch. Infinite Spin \u2013 Traps enemies with Act 4 hits. Spin Abilities \u2013 Use Steel Balls for sensory, paralysis, or massive damage.", "**Soft & Wet**: Shovel Chop (4pts, 10s) \u2013 Melee swing with stun. Finisher (5pts, 8s) \u2013 Knockback strike. Barrage (3pts, 4s) \u2013 Rapid punches. Shoot Bubble (1pt) \u2013 Fires a bubble with effect. Change Bubble Type (0pts, 2s) \u2013 Cycle bubble effects: Potion Infuse, No Friction, No Vision, No Stand. Bubble Counter (4pts, 12s) \u2013 Turn attacks into explosive bubbles. Bubble Enclosure (5pts, 5s) \u2013 Trap user inside floating bubble.", "**Wonder of U**: Calamity: Counter (0pts, 10s) \u2013 I-frame counter, damage gives Calamity Points. Calamity: Projectile (1pt, 5s) \u2013 Redirects all attacks to Calamity target. Calamity: Creeper (2pts, 5s) \u2013 Spawns creepers on each target. Calamity: Rain (3pts, 5s) \u2013 Increases damage during rain. Calamity: Heart Failure (5pts, 7s) \u2013 Targets lose 1/3 HP and gain Slowness.", "", "**The World / Over Heaven**: Chop (2pts) \u2013 Strong strike. Finisher (4pts) \u2013 Knockback blow. Barrage (3pts) \u2013 Fast punches (MUDA!). Grab (4pts) \u2013 Paralyze and weaken. Dimensional Shift (4pts) \u2013 Teleport away. Light Bolt Fury (6pts) \u2013 AoE divine lightning. Reality Rewrite: Change (0pts) \u2013 Switch between Mind Wash, Wound Eraser, Debuff Giver. Reality Rewrite: Use (4pts standing / 2pts crouch) \u2013 Apply current overwrite. Time Skip (3pts) \u2013 Blink with Speed and Jump Boost. Time Stop (5pts) \u2013 Freeze time. Time Resume (0pts) \u2013 End time stop early.");
    private int currentPage = 0;
    private final int paragraphsPerPage = 3;

    public CappySkillsExplenation() {
        super((Component)Component.literal((String)"Cappy Introduction"));
    }

    protected void init() {
        int centerX = this.width / 2;
        int bottomY = this.height - 40;
        int buttonWidth = 60;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> Minecraft.getInstance().setScreen((Screen)new CappyScreen())).bounds(centerX - 150, bottomY, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(centerX - 35, bottomY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2192"), b -> {
            if ((this.currentPage + 1) * 3 < this.paragraphs.size()) {
                ++this.currentPage;
            }
        }).bounds(centerX + 35, bottomY, buttonWidth, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderPanel(graphics);
        int x = 40;
        int y = 30;
        int lineHeight = 12;
        int paragraphSpacing = 10;
        List<String> currentParagraphs = this.getParagraphsForPage(this.currentPage);
        for (String paragraph : currentParagraphs) {
            List<String> lines = this.wrapText(paragraph, this.width - 80);
            for (String line : lines) {
                graphics.drawString(this.font, line, x, y, FastColor.ARGB32.color((int)255, (int)255, (int)255));
                y += lineHeight;
            }
            y += paragraphSpacing;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    private List<String> getParagraphsForPage(int page) {
        int start = page * 3;
        int end = Math.min(start + 3, this.paragraphs.size());
        return this.paragraphs.subList(start, end);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(line) + word) < maxWidth) {
                line.append(word).append(" ");
                continue;
            }
            result.add(line.toString().trim());
            line = new StringBuilder(word + " ");
        }
        if (!line.toString().isEmpty()) {
            result.add(line.toString().trim());
        }
        return result;
    }

    private void renderPanel(GuiGraphics graphics) {
        int padding = 20;
        int panelWidth = this.width - padding * 2;
        int panelHeight = this.height - padding * 2;
        int x1 = padding;
        int y1 = padding;
        int x2 = x1 + panelWidth;
        int y2 = y1 + panelHeight;
        graphics.fill(x1 - 2, y1 - 2, x2 + 2, y2 + 2, FastColor.ARGB32.color((int)255, (int)30, (int)30, (int)30));
        graphics.fill(x1, y1, x2, y2, FastColor.ARGB32.color((int)220, (int)50, (int)50, (int)50));
    }
}

