/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hrodebert.mots.Client.CappyScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class EvolvingStands
extends Screen {
    private final List<String> paragraphs = Arrays.asList("**Whitesnake \u2192 C-Moon**: Animate Dio's Bone with Limp Bizkit (the Stand with 4 stamina max), then kill 36 Pillagers while holding the bone in either hand. Right-click to track progress. After reaching 36 kills, right-click to transform it into the Green Baby. Interact with the baby to unlock the 'Evolve' ability. Go to The End and use 'Evolve' to become C-Moon.", "**C-Moon \u2192 Made in Heaven**: With C-Moon equipped, enter a forest biome and wait for a New Moon. Use the 'Evolve' ability during this time to ascend to Made in Heaven.", "**The World \u2192 The World Over Heaven**: Animate Dio's Bone with Limp Bizkit and kill 36 Pillagers while holding the bone. Right-click to track progress. Once complete, right-click to turn the bone into the Green Baby. Interact with it while The World is equipped to trigger the transformation.", "**Killer Queen \u2192 Soft & Wet**: Consume a Locacaca Fruit while having Killer Queen active to trigger the evolution into Soft & Wet.", "**Tusk Act 1 \u2192 Act 2**: Use the Golden Spin item to evolve to Act 2.", "**Tusk Act 2 \u2192 Act 3**: Use the Golden Rectangle ability repeatedly (training through usage).", "**Tusk Act 3 \u2192 Act 4**: Use the Golden Rectangle ability while riding a horse to unlock Act 4.");
    private int currentPage = 0;
    private final int paragraphsPerPage = 3;

    public EvolvingStands() {
        super((Component)Component.literal((String)"Cappy Introduction"));
    }

    protected void init() {
        int centerX = this.width / 2;
        int bottomY = this.height - 40;
        int buttonWidth = 60;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> Minecraft.getInstance().setScreen((Screen)new CappyScreen())).bounds(centerX - 150, bottomY, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(centerX - 35, bottomY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2192"), b -> {
            if ((this.currentPage + 1) * 3 < this.paragraphs.size()) {
                ++this.currentPage;
            }
        }).bounds(centerX + 35, bottomY, buttonWidth, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderPanel(graphics);
        int x = 40;
        int y = 30;
        int lineHeight = 12;
        int paragraphSpacing = 10;
        List<String> currentParagraphs = this.getParagraphsForPage(this.currentPage);
        for (String paragraph : currentParagraphs) {
            List<String> lines = this.wrapText(paragraph, this.width - 80);
            for (String line : lines) {
                graphics.drawString(this.font, line, x, y, FastColor.ARGB32.color((int)255, (int)255, (int)255));
                y += lineHeight;
            }
            y += paragraphSpacing;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    private List<String> getParagraphsForPage(int page) {
        int start = page * 3;
        int end = Math.min(start + 3, this.paragraphs.size());
        return this.paragraphs.subList(start, end);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(line) + word) < maxWidth) {
                line.append(word).append(" ");
                continue;
            }
            result.add(line.toString().trim());
            line = new StringBuilder(word + " ");
        }
        if (!line.toString().isEmpty()) {
            result.add(line.toString().trim());
        }
        return result;
    }

    private void renderPanel(GuiGraphics graphics) {
        int padding = 20;
        int panelWidth = this.width - padding * 2;
        int panelHeight = this.height - padding * 2;
        int x1 = padding;
        int y1 = padding;
        int x2 = x1 + panelWidth;
        int y2 = y1 + panelHeight;
        graphics.fill(x1 - 2, y1 - 2, x2 + 2, y2 + 2, FastColor.ARGB32.color((int)255, (int)30, (int)30, (int)30));
        graphics.fill(x1, y1, x2, y2, FastColor.ARGB32.color((int)220, (int)50, (int)50, (int)50));
    }
}

