/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skill;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismAttachments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="manifestation_of_the_souls", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class StandHudOverlay {
    private static final ResourceLocation ABILITY_ICON_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/ability_normal.png");
    private static final ResourceLocation ABILITY_ICON_SPECIAL = ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/ability_special.png");
    private static final ResourceLocation ABILITY_ICON_SPIN = ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/spin.png");
    private static final ResourceLocation ABILITY_ICON_CD = ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"textures/ui/cooldown.png");

    @SubscribeEvent
    public static void overlayRenderer(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"manifestation_of_the_souls", (String)"stand_layer"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            try {
                if (player.hasData(Attachments.HAS_STAND) && (Boolean)player.getData(Attachments.HAS_STAND) != false || player.hasData(Attachments.SPIN_AMOUNT.get()) && (Double)player.getData(Attachments.SPIN_AMOUNT.get()) > 0.0 || ((Boolean)player.getData(VampirismAttachments.IS_VAMPIRE)).booleanValue()) {
                    int y;
                    Font fontRenderer = minecraft.font;
                    ArrayList skills = new ArrayList((Collection)player.getData(Attachments.SKILLS));
                    if (player.hasData(Attachments.SPIN_SKILLS)) {
                        ((ArrayList)player.getData(Attachments.SPIN_SKILLS)).forEach(skill -> {
                            skill.icon = Optional.of(ABILITY_ICON_SPIN);
                            skills.add(skill);
                        });
                    }
                    int selectedSkillIndex = (Integer)player.getData(Attachments.SKILL);
                    int screenWidth = guiGraphics.guiWidth();
                    int screenHeight = guiGraphics.guiHeight();
                    float scale = 0.75f;
                    int iconSize = 32;
                    int scaledIconSize = (int)((float)iconSize * scale);
                    int spacing = 25;
                    int textWidth = 100;
                    int totalWidth = scaledIconSize + 5 + textWidth;
                    int x = 5;
                    int rectY = y = screenHeight / 2 - skills.size() * spacing / 2;
                    for (int i = 0; i < skills.size(); ++i) {
                        int textColor;
                        Skill skill2 = (Skill)skills.get(i);
                        Object skillText = skill2.name;
                        String costText = "Cost: " + skill2.cost;
                        Object cooldownText = "";
                        if ((Integer)player.getData(Attachments.COOLDOWN_TIME_ABILITY) > 0 && skill2.isSpecial.booleanValue()) {
                            cooldownText = "CD: " + (Integer)player.getData(Attachments.COOLDOWN_TIME_ABILITY) / 20 + "s";
                        } else if ((Integer)player.getData(Attachments.COOLDOWN_TIME_ATTACK) > 0 && !skill2.isSpecial.booleanValue()) {
                            cooldownText = "CD: " + (Integer)player.getData(Attachments.COOLDOWN_TIME_ATTACK) / 20 + "s";
                        }
                        ResourceLocation image = skill2.icon.orElse(skill2.isSpecial != false ? ABILITY_ICON_SPECIAL : ABILITY_ICON_NORMAL);
                        ResourceLocation image2 = skill2.icon.orElse(skill2.isSpecial != false ? ABILITY_ICON_SPECIAL : ABILITY_ICON_NORMAL);
                        if (!((String)cooldownText).isEmpty()) {
                            image2 = ABILITY_ICON_CD;
                        }
                        int iconX = x;
                        int iconY = rectY + i * spacing + 5;
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().translate((float)iconX, (float)iconY, 0.0f);
                        guiGraphics.pose().scale(scale, scale, 1.0f);
                        guiGraphics.blit(image, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                        guiGraphics.blit(image2, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                        guiGraphics.pose().popPose();
                        if (i == selectedSkillIndex) {
                            textColor = 0xFFFF00;
                            skillText = (String)skillText + " <";
                        } else {
                            textColor = 0xFFFFFF;
                        }
                        if (skill2.icon.isPresent() && skill2.icon.get().equals((Object)ABILITY_ICON_SPIN)) {
                            textColor = 0xAAFF00;
                        }
                        int textX = iconX + scaledIconSize + 5;
                        guiGraphics.drawString(fontRenderer, (String)skillText, textX, iconY + 2, textColor, false);
                        guiGraphics.drawString(fontRenderer, costText, textX, iconY + 12, 0xAAAAAA, false);
                        if (((String)cooldownText).isEmpty()) continue;
                        guiGraphics.drawString(fontRenderer, (String)cooldownText, textX + 50, iconY + 12, 0xFF0000, false);
                    }
                    int stamina = (Integer)player.getData(Attachments.STAMINA);
                    int maxStamina = (Integer)player.getData(Attachments.MAX_STAMINA);
                    String staminaText = "Stamina: " + stamina + "/" + maxStamina;
                    if (((Boolean)player.getData(Attachments.STAND_MODE)).booleanValue()) {
                        staminaText = "Stamina: " + stamina + "/" + maxStamina;
                    } else if (((Boolean)player.getData(VampirismAttachments.IS_VAMPIRE)).booleanValue()) {
                        String blood = Double.toString((Double)player.getData(Attachments.SPIN_AMOUNT));
                        Object f = "";
                        for (int i = 0; i < 5 && i != blood.length(); ++i) {
                            f = (String)f + blood.charAt(i);
                        }
                        staminaText = "Blood: " + (String)f + "/50";
                    } else {
                        staminaText = "Stamina: " + Double.toString((Double)player.getData(Attachments.SPIN_AMOUNT)) + "/50";
                    }
                    int lastSkillY = rectY + skills.size() * spacing + 5;
                    float textScale = 1.0f;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(textScale, textScale, 1.0f);
                    guiGraphics.drawString(fontRenderer, staminaText, (int)((float)x / textScale), (int)((float)lastSkillY / textScale), 65280, false);
                    guiGraphics.pose().popPose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

