/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import net.hrodebert.mots.ModItems.ModItems;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.MotsApi.Trait;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Rebirth {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"stand_rebirth").executes(Rebirth::learn));
    }

    private static int learn(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        Integer rebirthLevel = (Integer)player.getData(Attachments.STAND_REBIRTH);
        double requiredPower = StandHandler.getStandMaxPower((LivingEntity)player);
        if ((Double)player.getData(Attachments.STAND_ATTACK_POTENCY) >= requiredPower) {
            if ((Double)player.getData(Attachments.STAND_SPECIAL_POTENCY) >= requiredPower) {
                if ((Double)player.getData(Attachments.DAMAGE_RESISTANCE) >= requiredPower) {
                    Inventory inventory = player.getInventory();
                    int pos = -1;
                    for (int i = 0; i < inventory.items.size(); ++i) {
                        ItemStack stack = (ItemStack)inventory.items.get(i);
                        if (!stack.is((Item)ModItems.STAND_TABLET.get())) continue;
                        pos = i;
                        break;
                    }
                    if (rebirthLevel >= 2) {
                        if (pos == -1) {
                            player.sendSystemMessage((Component)Component.literal((String)"Please obtain a stand tablet first"));
                            return 1;
                        }
                        inventory.removeItem(pos, 1);
                    }
                    player.setData(Attachments.STAND_REBIRTH, (Object)Math.min(4, rebirthLevel + 1));
                    player.setData(Attachments.STAND_SPECIAL_POTENCY, (Object)0.0);
                    player.setData(Attachments.STAND_ATTACK_POTENCY, (Object)0.0);
                    player.setData(Attachments.DAMAGE_RESISTANCE, (Object)0.0);
                    if (rebirthLevel + 1 >= 4) {
                        player.setData(Attachments.STAND_TRAIT, (Object)Mots.traits.get(new Random().nextInt(Mots.traits.size())).getUUID().toString());
                        Trait obtainedTrait = StandHandler.getEntityTrait((LivingEntity)player);
                        player.sendSystemMessage((Component)Component.literal((String)("You obtained the trait: " + obtainedTrait.name + " (" + obtainedTrait.description + ")")));
                    }
                    StandHandler.syncData((LivingEntity)player);
                    player.sendSystemMessage((Component)Component.literal((String)("Rebirth executed, You now require " + StandHandler.getStandMaxPower((LivingEntity)player) + " In every stat to rebirth")));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)("You need to reach damage resistance : " + requiredPower + ", Please press: " + Component.keybind((String)"key.manifestation_of_the_souls.stand_stats").getString() + " to see your stats.")));
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)("You need to reach stand special level: " + requiredPower + ", Please press: " + Component.keybind((String)"key.manifestation_of_the_souls.stand_stats").getString() + " to see your stats.")));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)("You need to reach stand attack level: " + String.valueOf(requiredPower) + ", Please press: " + Component.keybind((String)"key.manifestation_of_the_souls.stand_stats").getString() + " to see your stats.")));
        }
        return 1;
    }
}

