/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.hrodebert.mots.ModItems.custom.ArrowHead;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SetEntityStand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setEntityStand").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"StandName", (ArgumentType)StringArgumentType.string()).suggests((ct, s) -> SharedSuggestionProvider.suggest(List.of("d4c", "whitesnake", "\"killer queen\"", "\"the world\"", "\"limp bizkit\"", "\"king crimson\"", "\"whitesnake (disc)\"", "c-moon", "\"made in heaven\"", "\"wonder of u\"", "\"crazy diamond\"", "\"Diver down\"", "\"Weather report\"", "\"soft & wet\"", "tusk", "\"golden experience\"").stream(), (SuggestionsBuilder)s)).executes(SetEntityStand::setStand))));
    }

    private static int setStand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String standName = StringArgumentType.getString(context, (String)"StandName");
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        int id = switch (standName.toLowerCase()) {
            case "d4c" -> 1;
            case "whitesnake" -> 2;
            case "killer queen" -> 3;
            case "the world" -> 4;
            case "king crimson" -> 5;
            case "limp bizkit" -> 6;
            case "whitesnake (disc)" -> 7;
            case "c-moon" -> 8;
            case "made in heaven" -> 9;
            case "wonder of u" -> 10;
            case "crazy diamond" -> 11;
            case "diver down" -> 12;
            case "weather report" -> 13;
            case "soft & wet" -> 14;
            case "tusk" -> 15;
            case "golden experience" -> 16;
            default -> -1;
        };
        entity.setData(Attachments.STAND_ID, (Object)id);
        ArrowHead.assignMaxStaminaByStandId(entity);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            StandHandler.syncData((LivingEntity)p);
        }
        return 1;
    }
}

