/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hrodebert.mots.ModDimensions.ModDimensions;
import net.hrodebert.mots.Mots;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.StandHandler;
import net.hrodebert.mots.ServerQueue.Queue;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TeleportPlayerToDimension {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"teleport_to_oh_dim").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(TeleportPlayerToDimension::learn)));
    }

    private static int learn(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if ((Integer)player.getData(Attachments.COOLDOWN_TIME_ABILITY) == 0) {
            StandHandler.applyCooldownAbility((LivingEntity)player, 100);
            player.setData(Attachments.STAMINA.get(), (Object)((Integer)player.getData(Attachments.STAMINA.get()) - 4));
            if ((Integer)player.getData(Attachments.STAND_ID) == 4 && ((Boolean)player.getData(Attachments.OVER_HEAVEN.get())).booleanValue()) {
                String targetPlayerUUID = StringArgumentType.getString(context, (String)"player");
                ServerPlayer targetPlayer = player.getServer().getPlayerList().getPlayer(UUID.fromString(targetPlayerUUID));
                targetPlayer.sendSystemMessage((Component)Component.literal((String)"<The world over heaven> my master requires your presence in my dimension"));
                targetPlayer.sendSystemMessage((Component)Component.literal((String)"(Do not move to get teleported)"));
                Vec3 originalPos = targetPlayer.position();
                AtomicBoolean teleport = new AtomicBoolean(true);
                for (int i = 0; i < 3; ++i) {
                    Mots.serverTaskExecutioner.tasks.add(new Queue.Task(i * 20, t -> {
                        if (teleport.get()) {
                            targetPlayer.sendSystemMessage((Component)Component.literal((String)("<The world over heaven> " + String.valueOf(3 - t / 20))));
                            if (!targetPlayer.position().equals((Object)originalPos)) {
                                teleport.set(false);
                            }
                        }
                    }));
                }
                Mots.serverTaskExecutioner.tasks.add(new Queue.Task(61, t -> {
                    if (teleport.get()) {
                        teleport.set(false);
                        ResourceKey<Level> resourcekey = targetPlayer.level().dimension() == ModDimensions.OH_DIM ? Level.OVERWORLD : ModDimensions.OH_DIM;
                        ServerLevel serverlevel = ((ServerLevel)targetPlayer.level()).getServer().getLevel(resourcekey);
                        targetPlayer.teleportTo(serverlevel, targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ(), null, targetPlayer.getYRot(), targetPlayer.getXRot());
                    }
                }));
            }
        }
        return 1;
    }
}

