/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Mixins;

import java.util.List;
import java.util.UUID;
import net.hrodebert.mots.ModEntities.custom.Cmoon;
import net.hrodebert.mots.MotsApi.Attachments;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityGravity
extends AttachmentHolder {
    @Shadow
    private Level level;
    @Shadow
    private boolean invulnerable;
    @Shadow
    public int invulnerableTime;
    @Shadow
    public int tickCount;

    @Shadow
    protected abstract double getDefaultGravity();

    @Shadow
    public abstract boolean isNoGravity();

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    public abstract List<Entity> getPassengers();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract boolean isInvulnerableTo(DamageSource var1);

    @Shadow
    public abstract UUID getUUID();

    @Inject(method={"getGravity"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void cameraVisibility(CallbackInfoReturnable<Double> cir) {
        double gravity = this.isNoGravity() ? 0.0 : this.getDefaultGravity();
        cir.setReturnValue((Object)gravity);
        try {
            this.level.getEntities(null, this.getBoundingBox().inflate(100.0)).forEach(entity -> {
                Cmoon c;
                if (entity instanceof Cmoon && (c = (Cmoon)((Object)entity)).isGravityInverted() && !this.getPassengers().contains((Object)c)) {
                    cir.setReturnValue((Object)(-1.0 * (Double)cir.getReturnValue()));
                }
            });
            if ((Double)cir.getReturnValue() < 0.0) {
                cir.setReturnValue((Object)-0.01);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"isAlliedTo*"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void isAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (((UUID)this.getData(Attachments.TW_OH_ALLY)).equals(entity.getUUID())) {
            cir.setReturnValue((Object)true);
        }
        if (((UUID)this.getData(Attachments.TW_OH_ALLY)).equals(entity.getData(Attachments.TW_OH_ALLY.get()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick*"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tick(CallbackInfo ci) {
        if (this.hasData(Attachments.TW_OH_ALLY)) {
            ServerLevel l;
            EntityAccess entityAccess;
            Level level;
            Player player;
            UUID uuid = (UUID)this.getData(Attachments.TW_OH_ALLY);
            if (this.level().getPlayerByUUID(uuid) != null && (Integer)(player = this.level().getPlayerByUUID(uuid)).getData(Attachments.STAND_ID) == 16 && (level = this.level()) instanceof ServerLevel && (entityAccess = (l = (ServerLevel)level).getEntities().get(this.getUUID())) instanceof Frog) {
                Frog frog = (Frog)entityAccess;
                Vec3 pos = (Vec3)player.getData(Attachments.TARGET_POS);
                frog.getNavigation().moveTo(pos.x, pos.y, pos.z, 2.0);
                if (frog.distanceToSqr(pos) <= 3.0) {
                    frog.kill();
                }
            }
        }
    }
}

