/*
 * Decompiled with CFR 0.152.
 */
package net.hrodebert.mots.Mixins;

import com.ibm.icu.impl.Pair;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.hrodebert.mots.Client.Utils;
import net.hrodebert.mots.ModEntities.custom.StandEntity;
import net.hrodebert.mots.MotsApi.Attachments;
import net.hrodebert.mots.MotsApi.Skills.Vampirism.VampirismAttachments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={net.minecraft.client.renderer.entity.EntityRenderer.class})
public abstract class EntityRenderer<T extends Entity> {
    private static final RenderType LASER_BEAM = RenderType.create((String)"laser_beam", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(true));
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    @Shadow
    public abstract ResourceLocation getTextureLocation(T var1);

    @Shadow
    public abstract void render(T var1, float var2, float var3, PoseStack var4, MultiBufferSource var5, int var6);

    @Inject(method={"render"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    private void isEntityUpsideDown(T p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        if (p_entity instanceof StandEntity && ((Entity)p_entity).tickCount < 16) {
            if (p_entity.hasData(Attachments.AVG)) {
                poseStack.pushPose();
                poseStack.translate(0.0, p_entity.getBoundingBox().getCenter().y - p_entity.getY(), 0.0);
                EntityRenderer.renderRaysWithColor(poseStack, -Math.abs((float)(1.5 * Math.sin((double)((Entity)p_entity).tickCount / 5.0))), bufferSource.getBuffer(RenderType.DRAGON_RAYS), (Integer)p_entity.getData(Attachments.AVG));
                poseStack.popPose();
            } else {
                Optional res = Minecraft.getInstance().getResourceManager().getResource(this.getTextureLocation(p_entity));
                if (res.isPresent()) {
                    try {
                        NativeImage pixels = NativeImage.read((InputStream)((Resource)res.get()).open());
                        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
                        for (int i = 0; i < pixels.getWidth(); ++i) {
                            for (int j = 0; j < pixels.getHeight(); ++j) {
                                int argb = pixels.getPixelRGBA(i, j);
                                int alpha = argb >> 24 & 0xFF;
                                if (alpha != 255) continue;
                                if (colorMap.containsKey(argb)) {
                                    colorMap.put(argb, (Integer)colorMap.get(argb) + 1);
                                    continue;
                                }
                                colorMap.put(argb, 1);
                            }
                        }
                        AtomicReference<Pair> bestMatch = new AtomicReference<Pair>(Pair.of((Object)0, (Object)Integer.MIN_VALUE));
                        colorMap.forEach((color, amount) -> {
                            int alpha = color >> 24 & 0xFF;
                            if (alpha == 255) {
                                int red = color >> 16 & 0xFF;
                                int green = color >> 8 & 0xFF;
                                int blue = color & 0xFF;
                                int distFromWhite = (255 - red) * (255 - red) + (255 - green) * (255 - green) + (255 - blue) * (255 - blue);
                                int score = amount * distFromWhite;
                                if (score > (Integer)((Pair)bestMatch.get()).second) {
                                    bestMatch.set(Pair.of((Object)color, (Object)score));
                                }
                            }
                        });
                        p_entity.setData(Attachments.AVG, (Object)((Integer)bestMatch.get().first));
                        poseStack.pushPose();
                        poseStack.translate(0.0, p_entity.getBoundingBox().getCenter().y - p_entity.getY(), 0.0);
                        EntityRenderer.renderRaysWithColor(poseStack, -Math.abs((float)Math.sin((double)((Entity)p_entity).tickCount / 5.0)), bufferSource.getBuffer(RenderType.DRAGON_RAYS), (Integer)bestMatch.get().first);
                        poseStack.popPose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (((Boolean)p_entity.getData(VampirismAttachments.IS_DOING_SPACE_RIPPER)).booleanValue()) {
            Utils.renderRipperSpaceEyes(p_entity, poseStack, partialTick, bufferSource.getBuffer(LASER_BEAM));
        }
    }

    private static void renderRaysWithColor(PoseStack poseStack, float f, VertexConsumer vertexConsumer, int color) {
        poseStack.pushPose();
        float g = Math.min(f > 0.8f ? (f - 0.8f) / 0.2f : 0.0f, 1.0f);
        int i = color;
        int j = 0xFF00FF;
        RandomSource randomSource = RandomSource.create((long)432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = Mth.floor((float)((f + f * f) / 2.0f * 60.0f));
        for (int l = 0; l < k; ++l) {
            quaternionf.rotationXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2) + f * 1.5707964f);
            poseStack.mulPose(quaternionf);
            float h = randomSource.nextFloat() * 20.0f + 5.0f + g * 10.0f;
            float m = randomSource.nextFloat() * 2.0f + 1.0f + g * 2.0f;
            vector3f2.set(-HALF_SQRT_3 * m, h, -0.5f * m);
            vector3f3.set(HALF_SQRT_3 * m, h, -0.5f * m);
            vector3f4.set(0.0f, h, m);
            PoseStack.Pose pose = poseStack.last();
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            int green = -12972273;
            vertexConsumer.addVertex(pose, vector3f2).setColor(green);
            vertexConsumer.addVertex(pose, vector3f3).setColor(green);
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            vertexConsumer.addVertex(pose, vector3f3).setColor(green);
            vertexConsumer.addVertex(pose, vector3f4).setColor(green);
            vertexConsumer.addVertex(pose, vector3f).setColor(i);
            vertexConsumer.addVertex(pose, vector3f4).setColor(green);
            vertexConsumer.addVertex(pose, vector3f2).setColor(green);
        }
        poseStack.popPose();
    }
}

